/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.backends.sftp;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import net.schmizz.sshj.Config;
import net.schmizz.sshj.DefaultConfig;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.LoggerFactory;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.FileMode;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.sftp.SFTPException;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.UserAuthException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;
import systems.reformcloud.reformcloud2.backends.sftp.SFTPConfig;
import systems.reformcloud.reformcloud2.executor.api.base.Conditions;
import systems.reformcloud.reformcloud2.executor.api.configuration.gson.JsonConfiguration;
import systems.reformcloud.reformcloud2.executor.api.groups.ProcessGroup;
import systems.reformcloud.reformcloud2.executor.api.groups.template.Template;
import systems.reformcloud.reformcloud2.executor.api.groups.template.backend.TemplateBackend;
import systems.reformcloud.reformcloud2.executor.api.groups.template.backend.TemplateBackendManager;
import systems.reformcloud.reformcloud2.executor.api.task.Task;
import systems.reformcloud.reformcloud2.executor.api.utility.list.Streams;

public final class SFTPTemplateBackend
implements TemplateBackend {
    private final SFTPConfig config;
    private SSHClient sshClient;
    private SFTPClient sftpClient;

    private SFTPTemplateBackend(SFTPConfig config) {
        this.config = config;
        this.ensureConnected();
    }

    public boolean existsTemplate(@NotNull String group, @NotNull String template) {
        this.ensureConnected();
        try {
            FileAttributes fileAttributes = this.sftpClient.statExistence(this.config.getBaseDirectory() + group + "/" + template);
            return fileAttributes != null && fileAttributes.getType() != null && fileAttributes.getType() == FileMode.Type.DIRECTORY;
        }
        catch (IOException exception) {
            return false;
        }
    }

    public void createTemplate(@NotNull String group, @NotNull String template) {
        Task.runAsync(() -> {
            this.ensureConnected();
            this.executeSilently(() -> this.sftpClient.mkdirs(this.config.getBaseDirectory() + group + "/" + template));
        });
    }

    @NotNull
    public Task<Void> loadTemplate(@NotNull String group, @NotNull String template, @NotNull Path target) {
        return this.executeTask(() -> this.downloadDirectory(this.config.getBaseDirectory() + group + "/" + template, target.toString()));
    }

    @NotNull
    public Task<Void> loadGlobalTemplates(@NotNull ProcessGroup group, @NotNull Path target) {
        ArrayList<Task<Void>> tasks = new ArrayList<Task<Void>>();
        for (Template template : group.getTemplates()) {
            if (!template.isGlobal()) continue;
            tasks.add(this.loadTemplate(group.getName(), template.getName(), target));
        }
        return Task.supply(() -> {
            while (Streams.hasMatch((Collection)tasks, t -> !t.isDone())) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException exception) {
                    break;
                }
            }
            return null;
        });
    }

    @NotNull
    public Task<Void> loadPath(@NotNull String path, @NotNull Path target) {
        return this.executeTask(() -> this.downloadDirectory(this.config.getBaseDirectory() + path, target.toString()));
    }

    public void deployTemplate(@NotNull String group, @NotNull String template, @NotNull Path current, @NotNull Collection<String> excluded) {
        Task.runAsync(() -> {
            this.executeSilently(() -> this.deleteDirectory(this.config.getBaseDirectory() + group + "/" + template));
            this.executeSilently(() -> this.uploadDirectory(this.config.getBaseDirectory() + group + "/" + template, current.toString(), excluded));
        });
    }

    public void deleteTemplate(@NotNull String group, @NotNull String template) {
        Task.runAsync(() -> {
            this.ensureConnected();
            this.executeSilently(() -> this.deleteDirectory(this.config.getBaseDirectory() + group + "/" + template));
        });
    }

    @NotNull
    public String getName() {
        return "SFTP";
    }

    @NotNull
    protected Task<Void> executeTask(@NotNull ExceptionRunnable runnable) {
        return Task.supply(() -> {
            this.ensureConnected();
            runnable.run();
            return null;
        });
    }

    protected boolean isReady() {
        return this.sshClient != null && this.sftpClient != null && this.sshClient.isConnected() && this.sshClient.isAuthenticated();
    }

    protected void ensureConnected() {
        if (!this.isReady()) {
            this.connect();
            Conditions.isTrue((boolean)this.isReady());
        }
    }

    protected void downloadDirectory(String remoteDir, String localDir) throws IOException {
        if (!remoteDir.endsWith("/")) {
            remoteDir = remoteDir + "/";
        }
        if (!localDir.endsWith("/")) {
            localDir = localDir + "/";
        }
        Path local = Paths.get(localDir, new String[0]);
        Files.createDirectories(local, new FileAttribute[0]);
        for (RemoteResourceInfo resourceInfo : this.sftpClient.ls(remoteDir)) {
            if (resourceInfo.isDirectory()) {
                this.downloadDirectory(remoteDir + resourceInfo.getName(), localDir + resourceInfo.getName());
                continue;
            }
            Files.createFile(local.resolve(resourceInfo.getName()), new FileAttribute[0]);
            this.sftpClient.get(remoteDir + resourceInfo.getName(), localDir + resourceInfo.getName());
        }
    }

    protected void deleteDirectory(String remoteDir) throws IOException {
        if (!remoteDir.endsWith("/")) {
            remoteDir = remoteDir + "/";
        }
        for (RemoteResourceInfo resourceInfo : this.sftpClient.ls(remoteDir)) {
            if (resourceInfo.isDirectory()) {
                this.deleteDirectory(remoteDir + resourceInfo.getName());
                continue;
            }
            this.sftpClient.rm(remoteDir + resourceInfo.getName());
        }
        this.sftpClient.rmdir(remoteDir);
    }

    protected void uploadDirectory(String remoteDir, String localDir, Collection<String> excluded) throws IOException {
        if (!remoteDir.endsWith("/")) {
            remoteDir = remoteDir + "/";
        }
        if (!localDir.endsWith("/")) {
            localDir = localDir + "/";
        }
        try {
            this.sftpClient.mkdir(remoteDir);
        }
        catch (SFTPException sFTPException) {
            // empty catch block
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get(localDir, new String[0]));){
            for (Path path : stream) {
                Path fileName = path.getFileName();
                if (fileName == null || excluded.contains(fileName.toString())) continue;
                if (Files.isDirectory(path, new LinkOption[0])) {
                    this.uploadDirectory(remoteDir + path.getFileName(), path.toString(), excluded);
                    continue;
                }
                this.sftpClient.put(path.toString(), remoteDir + fileName);
            }
        }
    }

    protected void connect() {
        this.sshClient = new SSHClient((Config)new InternalConfig());
        this.sshClient.setConnectTimeout(3000);
        this.sshClient.setTimeout(3000);
        this.sshClient.setRemoteCharset(StandardCharsets.UTF_8);
        if (this.config.getKnownHostsFile() == null) {
            this.executeSilently(() -> this.sshClient.loadKnownHosts());
            this.sshClient.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
        } else {
            try {
                this.sshClient.loadKnownHosts(new File(this.config.getKnownHostsFile()));
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
        try {
            this.sshClient.connect(this.config.getHost(), this.config.getPort());
        }
        catch (IOException exception) {
            throw new RuntimeException("Unable to connect to remote ssh host", exception);
        }
        try {
            if (this.config.getPrivateKeyFile() == null) {
                this.sshClient.authPassword(this.config.getUser(), this.config.getPassword());
            } else {
                this.sshClient.authPublickey(this.config.getUser(), new String[]{this.config.getPrivateKeyFile()});
            }
        }
        catch (UserAuthException exception) {
            throw new RuntimeException("Unable to authenticate with remote host", exception);
        }
        catch (TransportException exception) {
            throw new RuntimeException("Transportation exception while authenticating with remote host", exception);
        }
        try {
            this.sftpClient = this.sshClient.newSFTPClient();
        }
        catch (IOException exception) {
            throw new RuntimeException("Exception starting the sftp sub system", exception);
        }
    }

    protected void executeSilently(@NotNull ExceptionRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void load(String basePath) {
        SFTPConfig config;
        if (Files.notExists(Paths.get(basePath, "sftp.json"), new LinkOption[0])) {
            new JsonConfiguration().add("config", (Object)new SFTPConfig(false, "127.0.0.1", 22, "rc", "password", "rc/templates")).write(Paths.get(basePath, "sftp.json"));
        }
        if ((config = (SFTPConfig)JsonConfiguration.read((Path)Paths.get(basePath, "sftp.json")).get("config", SFTPConfig.class)) == null || !config.isEnabled()) {
            return;
        }
        config.validate();
        TemplateBackendManager.registerBackend((TemplateBackend)new SFTPTemplateBackend(config));
    }

    public static void unload() {
        TemplateBackendManager.unregisterBackend((String)"SFTP");
    }

    @FunctionalInterface
    private static interface ExceptionRunnable {
        public void run() throws Exception;
    }

    private static class InternalLoggingFactory
    implements LoggerFactory {
        private static final LoggerFactory NOP_FACTORY = new InternalLoggingFactory();

        private InternalLoggingFactory() {
        }

        public Logger getLogger(String name) {
            return NOPLogger.NOP_LOGGER;
        }

        public Logger getLogger(Class<?> clazz) {
            return NOPLogger.NOP_LOGGER;
        }
    }

    private static class InternalConfig
    extends DefaultConfig {
        private InternalConfig() {
        }

        public LoggerFactory getLoggerFactory() {
            return InternalLoggingFactory.NOP_FACTORY;
        }
    }
}

