/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.backends.sftp;

import systems.reformcloud.reformcloud2.executor.api.base.Conditions;

public final class SFTPConfig {
    private final boolean enabled;
    private final String host;
    private final int port;
    private final String user;
    private final String password;
    private final String privateKeyFile;
    private final String knownHostsFile;
    private String baseDirectory;

    public SFTPConfig(boolean enabled, String host, int port, String user, String password, String baseDirectory) {
        this.enabled = enabled;
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
        this.privateKeyFile = null;
        this.knownHostsFile = null;
        this.baseDirectory = baseDirectory;
    }

    public void validate() {
        if (!this.baseDirectory.startsWith("/")) {
            this.baseDirectory = "/" + this.baseDirectory;
        }
        if (!this.baseDirectory.endsWith("/")) {
            this.baseDirectory = this.baseDirectory + "/";
        }
        Conditions.isTrue((this.port >= 0 ? 1 : 0) != 0, (Object)"SSH Port must be higher than 0");
        Conditions.nonNull((Object)this.user, (Object)"Username has to be given");
        if (this.password == null) {
            Conditions.nonNull((Object)this.privateKeyFile, (Object)"If no user and password is given, the publickey has to be given");
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPrivateKeyFile() {
        return this.privateKeyFile;
    }

    public String getKnownHostsFile() {
        return this.knownHostsFile;
    }

    public String getBaseDirectory() {
        return this.baseDirectory.endsWith("/") ? this.baseDirectory : this.baseDirectory + "/";
    }
}

