/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.backends.url;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import systems.reformcloud.reformcloud2.executor.api.common.configuration.JsonConfiguration;
import systems.reformcloud.reformcloud2.executor.api.common.groups.ProcessGroup;
import systems.reformcloud.reformcloud2.executor.api.common.groups.template.backend.TemplateBackend;
import systems.reformcloud.reformcloud2.executor.api.common.groups.template.backend.TemplateBackendManager;
import systems.reformcloud.reformcloud2.executor.api.common.utility.list.Streams;
import systems.reformcloud.reformcloud2.executor.api.common.utility.system.DownloadHelper;
import systems.reformcloud.reformcloud2.executor.api.common.utility.system.SystemHelper;

public final class URLTemplateBackend
implements TemplateBackend {
    private final String basePath;

    public static void load(String basePath) {
        if (!Files.exists(Paths.get(basePath + "/url.json", new String[0]), new LinkOption[0])) {
            new JsonConfiguration().add("baseUrl", "https://127.0.0.1/rc/templates").write(Paths.get(basePath + "/url.json", new String[0]));
        }
        TemplateBackendManager.registerBackend((TemplateBackend)new URLTemplateBackend(JsonConfiguration.read((Path)Paths.get(basePath + "/url.json", new String[0]))));
    }

    public static void unload() {
        TemplateBackendManager.unregisterBackend((String)"URL");
    }

    private URLTemplateBackend(JsonConfiguration configuration) {
        this.basePath = configuration.getString("baseUrl");
    }

    public boolean existsTemplate(String group, String template) {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(this.getBasePath() + group + "-" + template + ".zip").openConnection();
            connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
            connection.setUseCaches(false);
            connection.connect();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Nonnull
    public CompletableFuture<Void> createTemplate(String group, String template) {
        return CompletableFuture.completedFuture(null);
    }

    @Nonnull
    public CompletableFuture<Void> loadTemplate(String group, String template, Path target) {
        DownloadHelper.downloadAndDisconnect((String)(this.getBasePath() + group + "-" + template + ".zip"), (String)"reformcloud/files/temp/template.zip");
        SystemHelper.unZip((File)new File("reformcloud/files/temp/template.zip"), (String)target.toString());
        SystemHelper.deleteFile((File)new File("reformcloud/files/temp/template.zip"));
        return CompletableFuture.completedFuture(null);
    }

    @Nonnull
    public CompletableFuture<Void> loadGlobalTemplates(ProcessGroup group, Path target) {
        Streams.allOf((Collection)group.getTemplates(), e -> e.getBackend().equals(this.getName()) && e.isGlobal()).forEach(e -> this.loadTemplate(group.getName(), e.getName(), target));
        return CompletableFuture.completedFuture(null);
    }

    @Nonnull
    public CompletableFuture<Void> deployTemplate(String group, String template, Path current) {
        return CompletableFuture.completedFuture(null);
    }

    public void deleteTemplate(String group, String template) {
    }

    private String getBasePath() {
        return this.basePath.endsWith("/") ? this.basePath : this.basePath + "/";
    }

    @Nonnull
    public String getName() {
        return "URL";
    }
}

