/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.backends.ftp;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPSClient;
import systems.reformcloud.reformcloud2.backends.ftp.FTPConfig;
import systems.reformcloud.reformcloud2.executor.api.common.configuration.JsonConfiguration;
import systems.reformcloud.reformcloud2.executor.api.common.groups.ProcessGroup;
import systems.reformcloud.reformcloud2.executor.api.common.groups.template.backend.TemplateBackend;
import systems.reformcloud.reformcloud2.executor.api.common.groups.template.backend.TemplateBackendManager;
import systems.reformcloud.reformcloud2.executor.api.common.network.NetworkUtil;
import systems.reformcloud.reformcloud2.executor.api.common.utility.list.Streams;
import systems.reformcloud.reformcloud2.executor.api.common.utility.system.SystemHelper;

public final class FTPTemplateBackend
implements TemplateBackend {
    private static final BlockingDeque<Runnable> TASKS = new LinkedBlockingDeque<Runnable>();
    private final FTPClient ftpClient;
    private final FTPConfig config;

    public static void load(String basePath) {
        FTPConfig config;
        if (Files.notExists(Paths.get(basePath, "ftp.json"), new LinkOption[0])) {
            new JsonConfiguration().add("config", (Object)new FTPConfig(false, false, "127.0.0.1", 21, "rc", "password", "rc/templates")).write(Paths.get(basePath, "ftp.json"));
        }
        if ((config = (FTPConfig)JsonConfiguration.read((Path)Paths.get(basePath, "ftp.json")).get("config", (TypeToken)new TypeToken<FTPConfig>(){})) == null || !config.isEnabled()) {
            return;
        }
        TemplateBackendManager.registerBackend((TemplateBackend)new FTPTemplateBackend(config));
    }

    public static void unload() {
        TemplateBackendManager.unregisterBackend((String)"FTP");
    }

    private FTPTemplateBackend(FTPConfig ftpConfig) {
        this.config = ftpConfig;
        this.ftpClient = ftpConfig.isSslEnabled() ? new FTPSClient() : new FTPClient();
        this.open(ftpConfig);
        NetworkUtil.EXECUTOR.execute(() -> {
            while (!Thread.interrupted()) {
                try {
                    Runnable runnable = TASKS.poll(20L, TimeUnit.SECONDS);
                    boolean available = this.ftpClient.isAvailable();
                    if (runnable == null) {
                        if (!available) continue;
                        try {
                            this.ftpClient.disconnect();
                        }
                        catch (Throwable throwable) {}
                        continue;
                    }
                    if (!available) {
                        this.open(this.config);
                    }
                    runnable.run();
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    public boolean existsTemplate(String group, String template) {
        if (this.ftpClient == null) {
            return false;
        }
        try {
            return this.ftpClient.listFiles(group + "/" + template).length > 0;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Nonnull
    public CompletableFuture<Void> createTemplate(String group, String template) {
        if (this.ftpClient == null) {
            return CompletableFuture.completedFuture(null);
        }
        return FTPTemplateBackend.future(() -> {
            try {
                this.makeDirectory(group + "/" + template);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        });
    }

    @Nonnull
    public CompletableFuture<Void> loadTemplate(String group, String template, Path target) {
        if (this.ftpClient == null) {
            return CompletableFuture.completedFuture(null);
        }
        return FTPTemplateBackend.future(() -> {
            try {
                FTPFile[] files = this.ftpClient.listFiles(group + "/" + template);
                if (files == null || files.length == 0) {
                    return;
                }
                for (FTPFile file : files) {
                    this.loadFiles(file, group + "/" + template + "/" + file.getName(), Paths.get(target.toString(), file.getName()));
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        });
    }

    private void loadFiles(FTPFile file, String path, Path target) throws IOException {
        if (file.isDirectory()) {
            FTPFile[] files = this.ftpClient.listFiles(path);
            if (files == null || files.length == 0) {
                return;
            }
            for (FTPFile ftpFile : files) {
                this.loadFiles(ftpFile, path + "/" + ftpFile.getName(), Paths.get(target.toString(), ftpFile.getName()));
            }
        } else if (file.isFile()) {
            SystemHelper.createDirectory((Path)target.getParent());
            if (Files.notExists(target, new LinkOption[0])) {
                Files.createFile(target, new FileAttribute[0]);
            }
            try (FileOutputStream fileOutputStream = new FileOutputStream(target.toFile(), false);){
                this.ftpClient.retrieveFile(path, (OutputStream)fileOutputStream);
            }
        }
        this.ftpClient.changeWorkingDirectory(this.config.getBaseDirectory());
    }

    @Nonnull
    public CompletableFuture<Void> loadGlobalTemplates(ProcessGroup group, Path target) {
        if (this.ftpClient == null) {
            return CompletableFuture.completedFuture(null);
        }
        return FTPTemplateBackend.future(() -> Streams.allOf((Collection)group.getTemplates(), e -> e.getBackend().equals(this.getName()) && e.isGlobal()).forEach(e -> this.loadTemplate(group.getName(), e.getName(), target)));
    }

    @Nonnull
    public CompletableFuture<Void> deployTemplate(String group, String template, Path current) {
        if (this.ftpClient == null) {
            return CompletableFuture.completedFuture(null);
        }
        File[] localFiles = current.toFile().listFiles();
        if (localFiles == null || localFiles.length == 0) {
            return CompletableFuture.completedFuture(null);
        }
        return FTPTemplateBackend.future(() -> {
            try {
                for (File localFile : localFiles) {
                    this.writeFile(group + "/" + template, localFile);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        });
    }

    private void writeFile(String path, File local) throws IOException {
        String remotePath = path + "/" + local.getName();
        if (local.isDirectory()) {
            File[] localFiles = local.listFiles();
            if (localFiles == null || localFiles.length == 0) {
                return;
            }
            this.makeDirectory(remotePath);
            for (File localFile : localFiles) {
                this.writeFile(remotePath, localFile);
            }
        } else if (local.isFile()) {
            try (FileInputStream inputStream = new FileInputStream(local);){
                this.ftpClient.storeFile(remotePath, (InputStream)inputStream);
            }
        }
        this.ftpClient.changeWorkingDirectory("/" + this.config.getBaseDirectory());
    }

    private void makeDirectory(String path) throws IOException {
        for (String s : path.split("/")) {
            if (!this.ftpClient.changeWorkingDirectory(s)) {
                this.ftpClient.makeDirectory(s);
            }
            this.ftpClient.changeWorkingDirectory(s);
        }
        this.ftpClient.changeWorkingDirectory(this.config.getBaseDirectory());
    }

    public void deleteTemplate(String group, String template) {
        if (this.ftpClient == null) {
            return;
        }
        TASKS.offerLast(() -> {
            try {
                FTPFile[] files = this.ftpClient.mlistDir(group + "/" + template);
                if (files == null || files.length == 0) {
                    return;
                }
                for (FTPFile file : files) {
                    this.deleteAll(group + "/" + template, file);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        });
    }

    private void deleteAll(String path, FTPFile file) throws IOException {
        String filePath = path + "/" + file.getName();
        if (file.isDirectory()) {
            FTPFile[] files = this.ftpClient.listFiles(filePath);
            if (files == null || files.length == 0) {
                return;
            }
            for (FTPFile ftpFile : files) {
                this.deleteAll(filePath, ftpFile);
            }
        } else {
            this.ftpClient.deleteFile(filePath);
        }
    }

    private static CompletableFuture<Void> future(@Nonnull Runnable runnable) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        Runnable newRunnable = () -> {
            runnable.run();
            completableFuture.complete(null);
        };
        TASKS.offerLast(newRunnable);
        return completableFuture;
    }

    private void open(FTPConfig ftpConfig) {
        try {
            this.ftpClient.setAutodetectUTF8(true);
            this.ftpClient.connect(ftpConfig.getHost(), ftpConfig.getPort());
            this.ftpClient.login(ftpConfig.getUser(), ftpConfig.getPassword());
            this.ftpClient.sendNoOp();
            this.ftpClient.setFileType(2);
            this.ftpClient.setControlKeepAliveTimeout(60L);
            this.makeDirectory(ftpConfig.getBaseDirectory());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Nonnull
    public String getName() {
        return "FTP";
    }
}

