/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.signs.util;

import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import systems.reformcloud.reformcloud2.executor.api.common.process.ProcessInformation;
import systems.reformcloud.reformcloud2.signs.util.converter.SignConverter;
import systems.reformcloud.reformcloud2.signs.util.sign.CloudLocation;
import systems.reformcloud.reformcloud2.signs.util.sign.CloudSign;
import systems.reformcloud.reformcloud2.signs.util.sign.config.SignConfig;

public interface SignSystemAdapter<T> {
    public static final String table = "reformcloud_internal_db_signs";
    public static final AtomicReference<SignSystemAdapter<?>> instance = new AtomicReference();

    public static SignSystemAdapter<?> getInstance() {
        return instance.get();
    }

    public void handleProcessStart(@NotNull ProcessInformation var1);

    public void handleProcessUpdate(@NotNull ProcessInformation var1);

    public void handleProcessStop(@NotNull ProcessInformation var1);

    @NotNull
    public CloudSign createSign(@NotNull T var1, @NotNull String var2);

    public void deleteSign(@NotNull CloudLocation var1);

    public void deleteAll();

    public void cleanSigns();

    @Nullable
    public CloudSign getSignAt(@NotNull CloudLocation var1);

    @NotNull
    public SignConverter<T> getSignConverter();

    public boolean canConnect(@NotNull CloudSign var1);

    @ApiStatus.Internal
    public void handleInternalSignCreate(@NotNull CloudSign var1);

    @ApiStatus.Internal
    public void handleInternalSignDelete(@NotNull CloudSign var1);

    @ApiStatus.Internal
    public void handleSignConfigUpdate(@NotNull SignConfig var1);
}

