/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.signs.nukkit.adapter;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockSignPost;
import cn.nukkit.blockentity.BlockEntitySign;
import cn.nukkit.command.CommandExecutor;
import cn.nukkit.command.PluginCommand;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.Listener;
import cn.nukkit.level.Location;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.plugin.PluginBase;
import cn.nukkit.utils.TextFormat;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import systems.reformcloud.reformcloud2.executor.api.common.CommonHelper;
import systems.reformcloud.reformcloud2.executor.api.common.process.ProcessInformation;
import systems.reformcloud.reformcloud2.executor.api.common.utility.annotiations.UndefinedNullability;
import systems.reformcloud.reformcloud2.signs.SharedSignSystemAdapter;
import systems.reformcloud.reformcloud2.signs.nukkit.adapter.NukkitSignConverter;
import systems.reformcloud.reformcloud2.signs.nukkit.commands.NukkitCommandSigns;
import systems.reformcloud.reformcloud2.signs.nukkit.listener.NukkitListener;
import systems.reformcloud.reformcloud2.signs.util.PlaceHolderUtil;
import systems.reformcloud.reformcloud2.signs.util.converter.SignConverter;
import systems.reformcloud.reformcloud2.signs.util.sign.CloudSign;
import systems.reformcloud.reformcloud2.signs.util.sign.config.SignConfig;
import systems.reformcloud.reformcloud2.signs.util.sign.config.SignSubLayout;

public class NukkitSignSystemAdapter
extends SharedSignSystemAdapter<BlockEntitySign> {
    private static final Map<String, Integer> BLOCKS = new ConcurrentHashMap<String, Integer>();
    private final PluginBase plugin;
    private static NukkitSignSystemAdapter instance;

    public NukkitSignSystemAdapter(@NotNull SignConfig signConfig, @NotNull PluginBase plugin) {
        super(signConfig);
        instance = this;
        this.plugin = plugin;
        Server.getInstance().getPluginManager().registerEvents((Listener)new NukkitListener(), (Plugin)plugin);
        PluginCommand command = (PluginCommand)plugin.getCommand("signs");
        command.setExecutor((CommandExecutor)new NukkitCommandSigns());
        command.setPermission("reformcloud.command.signs");
    }

    @Override
    protected void setSignLines(@Nullable BlockEntitySign blockEntitySign, @NotNull String[] lines) {
        if (blockEntitySign == null) {
            return;
        }
        blockEntitySign.setText(lines);
    }

    @Override
    protected void runTasks() {
        Server.getInstance().getScheduler().scheduleRepeatingTask((Plugin)this.plugin, this::updateSigns, CommonHelper.longToInt((long)(this.signConfig.getUpdateInterval() * 20L)));
        double distance = this.signConfig.getKnockBackDistance();
        Server.getInstance().getScheduler().scheduleDelayedRepeatingTask((Plugin)this.plugin, () -> {
            for (CloudSign sign : this.signs) {
                BlockEntitySign blockEntitySign = this.getSignConverter().from(sign);
                if (blockEntitySign == null) continue;
                Location location = blockEntitySign.getLocation();
                AxisAlignedBB alignedBB = new SimpleAxisAlignedBB((Vector3)location, (Vector3)location).expand(distance, distance, distance);
                for (Entity entity : location.getLevel().getNearbyEntities(alignedBB)) {
                    Player player;
                    if (!(entity instanceof Player) || (player = (Player)entity).hasPermission(this.signConfig.getKnockBackBypassPermission())) continue;
                    Vector3 vector = player.getPosition().subtract((Vector3)location).normalize().multiply(this.signConfig.getKnockBackStrength());
                    vector.y = 0.2;
                    player.setMotion(vector);
                }
            }
        }, 20, 5);
    }

    @Override
    @NotNull
    protected String replaceAll(@NotNull String line, @NotNull String group, @Nullable ProcessInformation processInformation) {
        if (processInformation == null) {
            line = line.replace("%group%", group);
            return TextFormat.colorize((char)'&', (String)line);
        }
        return PlaceHolderUtil.format(line, group, processInformation, s -> TextFormat.colorize((char)'&', (String)s));
    }

    @Override
    public void changeBlock(@NotNull CloudSign sign, @NotNull SignSubLayout layout) {
        BlockEntitySign blockEntitySign = this.getSignConverter().from(sign);
        if (blockEntitySign == null) {
            return;
        }
        this.changeBlock0(blockEntitySign, layout);
    }

    @Override
    @NotNull
    public SignConverter<BlockEntitySign> getSignConverter() {
        return NukkitSignConverter.INSTANCE;
    }

    @Override
    public void handleSignConfigUpdate(@NotNull SignConfig config) {
        this.signConfig = config;
        this.restartTasks();
    }

    @UndefinedNullability
    public static NukkitSignSystemAdapter getInstance() {
        return instance;
    }

    private void changeBlock0(@NotNull BlockEntitySign sign, @NotNull SignSubLayout layout) {
        if (!(sign.getBlock() instanceof BlockSignPost)) {
            return;
        }
        BlockSignPost post = (BlockSignPost)sign.getBlock();
        Location location = post.getSide(post.getBlockFace().getOpposite()).getLocation();
        Integer block = BLOCKS.get(layout.getBlock());
        if (block == null) {
            return;
        }
        Block nukkitBlock = Block.fullList[(block << 4) + layout.getSubID()].clone();
        location.getLevel().setBlock((Vector3)location, nukkitBlock, true, true);
    }

    private void restartTasks() {
        Server.getInstance().getScheduler().cancelTask((Plugin)this.plugin);
        this.runTasks();
    }

    static {
        Arrays.stream(Block.fullList).forEach(e -> BLOCKS.put(e.getName(), e.getId()));
    }
}

