/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.signs.bukkit.adapter;

import java.util.Optional;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.data.Directional;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import systems.reformcloud.reformcloud2.executor.api.common.base.Conditions;
import systems.reformcloud.reformcloud2.executor.api.common.process.ProcessInformation;
import systems.reformcloud.reformcloud2.signs.SharedSignSystemAdapter;
import systems.reformcloud.reformcloud2.signs.bukkit.adapter.BukkitSignConverter;
import systems.reformcloud.reformcloud2.signs.bukkit.commands.BukkitCommandSigns;
import systems.reformcloud.reformcloud2.signs.bukkit.listener.BukkitListener;
import systems.reformcloud.reformcloud2.signs.util.PlaceHolderUtil;
import systems.reformcloud.reformcloud2.signs.util.converter.SignConverter;
import systems.reformcloud.reformcloud2.signs.util.sign.CloudSign;
import systems.reformcloud.reformcloud2.signs.util.sign.config.SignConfig;
import systems.reformcloud.reformcloud2.signs.util.sign.config.SignSubLayout;

public class BukkitSignSystemAdapter
extends SharedSignSystemAdapter<Sign> {
    private static BukkitSignSystemAdapter instance;
    private final Plugin plugin;

    public BukkitSignSystemAdapter(JavaPlugin plugin, SignConfig config) {
        super(config);
        instance = this;
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)new BukkitListener(), (Plugin)plugin);
        PluginCommand signs = plugin.getCommand("signs");
        Conditions.isTrue((signs != null ? 1 : 0) != 0);
        signs.setExecutor((CommandExecutor)new BukkitCommandSigns());
        signs.setPermission("reformcloud.command.signs");
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)plugin, "BungeeCord");
    }

    @Override
    protected void setSignLines(@Nullable Sign sign, @NotNull String[] lines) {
        if (sign != null && lines.length == 4) {
            for (int i = 0; i < 4; ++i) {
                sign.setLine(i, lines[i]);
            }
            sign.update();
        }
    }

    @Override
    public void handleSignConfigUpdate(@NotNull SignConfig config) {
        this.signConfig = config;
        this.restartTask();
    }

    @Override
    @NotNull
    public SignConverter<Sign> getSignConverter() {
        return BukkitSignConverter.INSTANCE;
    }

    @Override
    @Nonnull
    protected String replaceAll(@Nonnull String line, @Nonnull String group, ProcessInformation processInformation) {
        if (processInformation == null) {
            line = line.replace("%group%", group);
            return ChatColor.translateAlternateColorCodes((char)'&', (String)line);
        }
        return PlaceHolderUtil.format(line, group, processInformation, s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s));
    }

    @Override
    public void changeBlock(@NotNull CloudSign sign, @NotNull SignSubLayout layout) {
        Sign bukkit = this.getSignConverter().from(sign);
        if (bukkit != null) {
            if (Bukkit.isPrimaryThread()) {
                this.changeBlockBehind(bukkit, layout);
            } else {
                Bukkit.getScheduler().runTask(this.plugin, () -> this.changeBlockBehind(bukkit, layout));
            }
        }
    }

    private void changeBlockBehind(Sign sign, SignSubLayout layout) {
        BlockFace blockFace;
        block3: {
            blockFace = null;
            try {
                org.bukkit.material.Sign signData = (org.bukkit.material.Sign)sign.getData();
                if (signData.isWallSign()) {
                    blockFace = signData.getFacing();
                }
            }
            catch (Throwable throwable) {
                if (!(sign.getBlockData() instanceof Directional)) break block3;
                Directional directional = (Directional)sign.getBlockData();
                blockFace = directional.getFacing();
            }
        }
        this.getRelative(blockFace).ifPresent(e -> {
            Material material = Material.getMaterial((String)layout.getBlock());
            if (material == null) {
                return;
            }
            BlockState back = sign.getBlock().getRelative(e).getState();
            back.setType(material);
            back.setData(new MaterialData(material, (byte)layout.getSubID()));
            back.update(true);
        });
    }

    private Optional<BlockFace> getRelative(BlockFace face) {
        if (face == null) {
            return Optional.empty();
        }
        switch (face) {
            case EAST: {
                return Optional.of(BlockFace.WEST);
            }
            case WEST: {
                return Optional.of(BlockFace.EAST);
            }
            case NORTH: {
                return Optional.of(BlockFace.SOUTH);
            }
            case SOUTH: {
                return Optional.of(BlockFace.NORTH);
            }
        }
        return Optional.empty();
    }

    private void restartTask() {
        Bukkit.getScheduler().cancelTasks(this.plugin);
        this.runTasks();
    }

    @Override
    protected void runTasks() {
        Bukkit.getScheduler().runTaskTimer(this.plugin, this::updateSigns, 0L, 20L * this.signConfig.getUpdateInterval());
        double distance = this.signConfig.getKnockBackDistance();
        Bukkit.getScheduler().scheduleSyncRepeatingTask(this.plugin, () -> {
            for (CloudSign cachedSign : this.signs) {
                Location location;
                Sign bukkitSign = this.getSignConverter().from(cachedSign);
                if (bukkitSign == null || (location = bukkitSign.getLocation()).getWorld() == null) continue;
                location.getWorld().getNearbyEntities(location, distance, distance, distance).stream().filter(e -> e instanceof Player && !e.hasPermission(this.signConfig.getKnockBackBypassPermission())).forEach(e -> e.setVelocity(e.getLocation().toVector().subtract(location.toVector()).normalize().multiply(this.signConfig.getKnockBackStrength()).setY(0.2)));
            }
        }, 20L, 5L);
    }

    public static BukkitSignSystemAdapter getInstance() {
        return instance;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }
}

