/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.signs.nukkit.commands;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.blockentity.BlockEntitySign;
import cn.nukkit.command.Command;
import cn.nukkit.command.CommandExecutor;
import cn.nukkit.command.CommandSender;
import cn.nukkit.math.Vector3;
import systems.reformcloud.reformcloud2.executor.api.common.ExecutorAPI;
import systems.reformcloud.reformcloud2.signs.nukkit.adapter.NukkitSignSystemAdapter;
import systems.reformcloud.reformcloud2.signs.util.sign.CloudSign;

public class NukkitCommandSigns
implements CommandExecutor {
    public boolean onCommand(CommandSender commandSender, Command command, String s, String[] strings) {
        if (!commandSender.hasPermission("reformcloud.command.signs") || !(commandSender instanceof Player)) {
            return true;
        }
        Player player = (Player)commandSender;
        if (strings.length == 2 && strings[0].equalsIgnoreCase("create")) {
            if (ExecutorAPI.getInstance().getSyncAPI().getGroupSyncAPI().getProcessGroup(strings[1]) == null) {
                commandSender.sendMessage("\u00a77The process group " + strings[1] + " does not exists");
                return true;
            }
            Block block = player.getTargetBlock(15);
            if (block == null || !(block.getLevel().getBlockEntity((Vector3)block.getLocation()) instanceof BlockEntitySign)) {
                commandSender.sendMessage("\u00a7cThe target Block is not a sign");
                return true;
            }
            BlockEntitySign entitySign = (BlockEntitySign)block.getLevel().getBlockEntity((Vector3)block.getLocation());
            CloudSign cloudSign = NukkitSignSystemAdapter.getInstance().getSignAt(NukkitSignSystemAdapter.getInstance().getSignConverter().to(entitySign));
            if (cloudSign != null) {
                commandSender.sendMessage("\u00a7cThe sign already exists");
                return true;
            }
            NukkitSignSystemAdapter.getInstance().createSign(entitySign, strings[1]);
            commandSender.sendMessage("\u00a77Created the sign successfully, please wait a second...");
            return true;
        }
        if (strings.length == 1 && strings[0].equalsIgnoreCase("delete")) {
            Block block = player.getTargetBlock(15);
            if (block == null || !(block.getLevel().getBlockEntity((Vector3)block.getLocation()) instanceof BlockEntitySign)) {
                commandSender.sendMessage("\u00a7cThe target Block is not a sign");
                return true;
            }
            BlockEntitySign entitySign = (BlockEntitySign)block.getLevel().getBlockEntity((Vector3)block.getLocation());
            CloudSign cloudSign = NukkitSignSystemAdapter.getInstance().getSignAt(NukkitSignSystemAdapter.getInstance().getSignConverter().to(entitySign));
            if (cloudSign == null) {
                commandSender.sendMessage("\u00a7cThe sign does not exists");
                return true;
            }
            NukkitSignSystemAdapter.getInstance().deleteSign(cloudSign.getLocation());
            commandSender.sendMessage("\u00a77Deleted sign, please wait a second...");
            return true;
        }
        commandSender.sendMessage("\u00a77/signs create [group]");
        commandSender.sendMessage("\u00a77/signs delete");
        return true;
    }
}

