/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.signs.bukkit.adapter;

import com.google.gson.reflect.TypeToken;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.Directional;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.event.Listener;
import org.bukkit.material.MaterialData;
import org.bukkit.material.Sign;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import systems.reformcloud.reformcloud2.executor.api.common.ExecutorAPI;
import systems.reformcloud.reformcloud2.executor.api.common.base.Conditions;
import systems.reformcloud.reformcloud2.executor.api.common.network.channel.handler.NetworkHandler;
import systems.reformcloud.reformcloud2.executor.api.common.network.channel.manager.DefaultChannelManager;
import systems.reformcloud.reformcloud2.executor.api.common.network.packet.Packet;
import systems.reformcloud.reformcloud2.executor.api.common.process.ProcessInformation;
import systems.reformcloud.reformcloud2.executor.api.common.process.ProcessState;
import systems.reformcloud.reformcloud2.executor.api.common.utility.list.Streams;
import systems.reformcloud.reformcloud2.executor.api.common.utility.task.Task;
import systems.reformcloud.reformcloud2.signs.bukkit.adapter.BukkitSignConverter;
import systems.reformcloud.reformcloud2.signs.bukkit.commands.BukkitCommandSigns;
import systems.reformcloud.reformcloud2.signs.bukkit.listener.BukkitListener;
import systems.reformcloud.reformcloud2.signs.listener.CloudListener;
import systems.reformcloud.reformcloud2.signs.packets.api.in.APIPacketInCreateSign;
import systems.reformcloud.reformcloud2.signs.packets.api.in.APIPacketInDeleteSign;
import systems.reformcloud.reformcloud2.signs.packets.api.in.APIPacketInReloadConfig;
import systems.reformcloud.reformcloud2.signs.packets.api.out.APIPacketOutCreateSign;
import systems.reformcloud.reformcloud2.signs.packets.api.out.APIPacketOutDeleteSign;
import systems.reformcloud.reformcloud2.signs.util.LayoutUtil;
import systems.reformcloud.reformcloud2.signs.util.PlaceHolderUtil;
import systems.reformcloud.reformcloud2.signs.util.SignSystemAdapter;
import systems.reformcloud.reformcloud2.signs.util.converter.SignConverter;
import systems.reformcloud.reformcloud2.signs.util.sign.CloudLocation;
import systems.reformcloud.reformcloud2.signs.util.sign.CloudSign;
import systems.reformcloud.reformcloud2.signs.util.sign.config.SignConfig;
import systems.reformcloud.reformcloud2.signs.util.sign.config.SignLayout;
import systems.reformcloud.reformcloud2.signs.util.sign.config.SignSubLayout;

public class BukkitSignSystemAdapter
implements SignSystemAdapter<org.bukkit.block.Sign> {
    private static BukkitSignSystemAdapter instance;
    private SignConfig config;
    private final Plugin plugin;
    private final List<CloudSign> cachedSigns = new LinkedList<CloudSign>();
    private int taskID = -1;
    private Map<UUID, ProcessInformation> notAssigned = new ConcurrentHashMap<UUID, ProcessInformation>();
    private final AtomicInteger[] counter = new AtomicInteger[]{new AtomicInteger(-1), new AtomicInteger(-1), new AtomicInteger(-1), new AtomicInteger(-1), new AtomicInteger(-1), new AtomicInteger(-1)};

    public BukkitSignSystemAdapter(JavaPlugin plugin, SignConfig config) {
        instance = this;
        SignSystemAdapter.instance.set(instance);
        this.plugin = plugin;
        this.config = config;
        ExecutorAPI.getInstance().getEventManager().registerListener((Object)new CloudListener());
        Bukkit.getPluginManager().registerEvents((Listener)new BukkitListener(), (Plugin)plugin);
        PluginCommand signs = plugin.getCommand("signs");
        Conditions.isTrue((signs != null ? 1 : 0) != 0);
        signs.setExecutor((CommandExecutor)new BukkitCommandSigns());
        signs.setPermission("reformcloud.command.signs");
        ExecutorAPI.getInstance().getPacketHandler().registerNetworkHandlers(new NetworkHandler[]{new APIPacketInCreateSign(), new APIPacketInDeleteSign(), new APIPacketInReloadConfig()});
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)plugin, "BungeeCord");
        this.start();
    }

    @Override
    public void handleProcessStart(@Nonnull ProcessInformation processInformation) {
        if (!processInformation.getTemplate().isServer()) {
            return;
        }
        if (this.isCurrent(processInformation)) {
            return;
        }
        this.assign(processInformation);
        this.updateAllSigns();
    }

    @Override
    public void handleProcessUpdate(@Nonnull ProcessInformation processInformation) {
        if (!processInformation.getTemplate().isServer()) {
            return;
        }
        if (this.isCurrent(processInformation)) {
            return;
        }
        if (this.notAssigned.containsKey(processInformation.getProcessUniqueID())) {
            this.notAssigned.put(processInformation.getProcessUniqueID(), processInformation);
            return;
        }
        this.updateAssign(processInformation);
        this.updateAllSigns();
    }

    @Override
    public void handleProcessStop(@Nonnull ProcessInformation processInformation) {
        if (!processInformation.getTemplate().isServer()) {
            return;
        }
        if (this.isCurrent(processInformation)) {
            return;
        }
        this.deleteAssignment(processInformation);
        this.updateAllSigns();
    }

    @Override
    @Nonnull
    public CloudSign createSign(@Nonnull org.bukkit.block.Sign sign, @Nonnull String group) {
        CloudSign cloudSign = this.getSignConverter().to(sign, group);
        if (this.getSignAt(cloudSign.getLocation()) != null) {
            return cloudSign;
        }
        DefaultChannelManager.INSTANCE.get("Controller").ifPresent(e -> e.sendPacket((Packet)new APIPacketOutCreateSign(cloudSign)));
        return cloudSign;
    }

    @Override
    public void deleteSign(@Nonnull CloudLocation location) {
        Streams.filterToReference(this.cachedSigns, e -> e.getLocation().equals(location)).ifPresent(e -> DefaultChannelManager.INSTANCE.get("Controller").ifPresent(s -> s.sendPacket((Packet)new APIPacketOutDeleteSign((CloudSign)e))));
    }

    @Override
    @Nullable
    public CloudSign getSignAt(@Nonnull CloudLocation location) {
        return (CloudSign)Streams.filter(this.cachedSigns, e -> e.getLocation().equals(location));
    }

    @Override
    @Nonnull
    public SignConverter<org.bukkit.block.Sign> getSignConverter() {
        return BukkitSignConverter.INSTANCE;
    }

    @Override
    public boolean canConnect(@Nonnull CloudSign cloudSign) {
        if (cloudSign.getCurrentTarget() == null || !cloudSign.getCurrentTarget().getNetworkInfo().isConnected()) {
            return false;
        }
        if (cloudSign.getCurrentTarget().getProcessGroup().getPlayerAccessConfiguration().isMaintenance()) {
            return this.getSelfLayout().isShowMaintenanceProcessesOnSigns();
        }
        return true;
    }

    @Override
    public void handleInternalSignCreate(@Nonnull CloudSign cloudSign) {
        this.cachedSigns.add(cloudSign);
        this.tryAssign();
        this.updateAllSigns();
    }

    @Override
    public void handleInternalSignDelete(@Nonnull CloudSign cloudSign) {
        Streams.filterToReference(this.cachedSigns, e -> e.getLocation().equals(cloudSign.getLocation())).ifPresent(e -> {
            this.cachedSigns.remove(e);
            this.removeAssign((CloudSign)e);
            this.updateAllSigns();
            this.doSync(() -> this.clearLines(this.getSignConverter().from((CloudSign)e)));
        });
    }

    @Override
    public void handleSignConfigUpdate(@Nonnull SignConfig config) {
        this.config = config;
        this.restartTask();
    }

    private void clearLines(org.bukkit.block.Sign sign) {
        if (sign == null) {
            return;
        }
        sign.setLine(0, " ");
        sign.setLine(1, " ");
        sign.setLine(2, " ");
        sign.setLine(3, " ");
        sign.update();
    }

    private void doSync(Runnable runnable) {
        if (!this.plugin.isEnabled()) {
            return;
        }
        Bukkit.getScheduler().runTask(this.plugin, runnable);
    }

    private void assign(ProcessInformation processInformation) {
        for (CloudSign sign : this.cachedSigns) {
            if (sign.getCurrentTarget() != null || !sign.getGroup().equals(processInformation.getProcessGroup().getName())) continue;
            sign.setCurrentTarget(processInformation);
            this.notAssigned.remove(processInformation.getProcessUniqueID());
            return;
        }
        this.notAssigned.put(processInformation.getProcessUniqueID(), processInformation);
    }

    private void updateAssign(ProcessInformation newInfo) {
        for (CloudSign sign : this.cachedSigns) {
            if (sign.getCurrentTarget() == null || !sign.getCurrentTarget().getProcessUniqueID().equals(newInfo.getProcessUniqueID())) continue;
            sign.setCurrentTarget(newInfo);
            break;
        }
    }

    private void deleteAssignment(ProcessInformation processInformation) {
        for (CloudSign sign : this.cachedSigns) {
            if (sign.getCurrentTarget() == null || !sign.getCurrentTarget().getProcessUniqueID().equals(processInformation.getProcessUniqueID())) continue;
            sign.setCurrentTarget(null);
            return;
        }
        this.notAssigned.remove(processInformation.getProcessUniqueID());
    }

    private void tryAssign() {
        if (this.notAssigned.isEmpty()) {
            return;
        }
        this.notAssigned.values().forEach(this::assign);
    }

    private void removeAssign(CloudSign sign) {
        if (sign.getCurrentTarget() == null) {
            return;
        }
        this.notAssigned.put(sign.getCurrentTarget().getProcessUniqueID(), sign.getCurrentTarget());
        sign.setCurrentTarget(null);
        this.tryAssign();
    }

    private void updateAllSigns() {
        this.doSync(this::updateAllSigns0);
    }

    private void updateAllSigns0() {
        SignLayout layout = this.getSelfLayout();
        SignSubLayout searching = LayoutUtil.getNextAndCheckFor(layout.getSearchingLayouts(), this.counter[0]).orElseThrow(() -> new RuntimeException("Waiting layout for current group not present"));
        SignSubLayout maintenance = LayoutUtil.getNextAndCheckFor(layout.getMaintenanceLayout(), this.counter[5]).orElseThrow(() -> new RuntimeException("Waiting layout for current group not present"));
        SignSubLayout connecting = LayoutUtil.getNextAndCheckFor(layout.getWaitingForConnectLayout(), this.counter[1]).orElseThrow(() -> new RuntimeException("Connecting layout for current group not present"));
        SignSubLayout empty = LayoutUtil.getNextAndCheckFor(layout.getEmptyLayout(), this.counter[2]).orElseThrow(() -> new RuntimeException("Empty layout for current group not present"));
        SignSubLayout full = LayoutUtil.getNextAndCheckFor(layout.getFullLayout(), this.counter[4]).orElseThrow(() -> new RuntimeException("Empty layout for current group not present"));
        SignSubLayout online = LayoutUtil.getNextAndCheckFor(layout.getOnlineLayout(), this.counter[3]).orElseThrow(() -> new RuntimeException("Empty layout for current group not present"));
        this.cachedSigns.forEach(e -> {
            if (e.getCurrentTarget() == null) {
                this.updateSign((CloudSign)e, searching, null);
                return;
            }
            if (e.getCurrentTarget().getProcessState().equals((Object)ProcessState.INVISIBLE) || e.getCurrentTarget().getProcessState().equals((Object)ProcessState.STOPPED) || e.getCurrentTarget().getProcessState().equals((Object)ProcessState.STARTED) || e.getCurrentTarget().getProcessState().equals((Object)ProcessState.PREPARED)) {
                this.updateSign((CloudSign)e, searching, null);
                return;
            }
            if (e.getCurrentTarget().getProcessGroup().getPlayerAccessConfiguration().isMaintenance()) {
                if (layout.isShowMaintenanceProcessesOnSigns()) {
                    this.updateSign((CloudSign)e, maintenance, e.getCurrentTarget());
                    return;
                }
                this.updateSign((CloudSign)e, searching, null);
                return;
            }
            if (!e.getCurrentTarget().getNetworkInfo().isConnected()) {
                this.updateSign((CloudSign)e, connecting, e.getCurrentTarget());
                return;
            }
            if (e.getCurrentTarget().getOnlineCount() == 0) {
                this.updateSign((CloudSign)e, empty, e.getCurrentTarget());
                return;
            }
            if (e.getCurrentTarget().getOnlineCount() >= e.getCurrentTarget().getMaxPlayers()) {
                if (layout.isSearchingLayoutWhenFull()) {
                    this.updateSign((CloudSign)e, searching, null);
                    return;
                }
                this.updateSign((CloudSign)e, full, e.getCurrentTarget());
                return;
            }
            this.updateSign((CloudSign)e, online, e.getCurrentTarget());
        });
    }

    private void updateSign(CloudSign sign, SignSubLayout layout, ProcessInformation processInformation) {
        org.bukkit.block.Sign bukkit = this.getSignConverter().from(sign);
        if (bukkit == null || layout.getLines() == null || layout.getLines().length != 4) {
            return;
        }
        bukkit.setLine(0, this.replaceAll(layout.getLines()[0], sign.getGroup(), processInformation));
        bukkit.setLine(1, this.replaceAll(layout.getLines()[1], sign.getGroup(), processInformation));
        bukkit.setLine(2, this.replaceAll(layout.getLines()[2], sign.getGroup(), processInformation));
        bukkit.setLine(3, this.replaceAll(layout.getLines()[3], sign.getGroup(), processInformation));
        bukkit.update();
        this.changeBlockBehind(bukkit, layout);
    }

    private String replaceAll(String line, String group, ProcessInformation processInformation) {
        if (processInformation == null) {
            line = line.replace("%group%", group);
            return ChatColor.translateAlternateColorCodes((char)'&', (String)line);
        }
        return PlaceHolderUtil.format(line, group, processInformation, s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s));
    }

    private void changeBlockBehind(org.bukkit.block.Sign sign, SignSubLayout layout) {
        BlockFace blockFace;
        block3: {
            blockFace = null;
            try {
                Sign signData = (Sign)sign.getData();
                if (signData.isWallSign()) {
                    blockFace = signData.getFacing();
                }
            }
            catch (Throwable throwable) {
                if (!(sign.getBlockData() instanceof Directional)) break block3;
                Directional directional = (Directional)sign.getBlockData();
                blockFace = directional.getFacing();
            }
        }
        this.getRelative(blockFace).ifPresent(e -> {
            Material material = Material.getMaterial((String)layout.getBlock());
            if (material == null) {
                return;
            }
            BlockState back = sign.getBlock().getRelative(e).getState();
            back.setType(material);
            back.setData(new MaterialData(material, (byte)layout.getSubID()));
            back.update(true);
        });
    }

    private Optional<BlockFace> getRelative(BlockFace face) {
        if (face == null) {
            return Optional.empty();
        }
        switch (face) {
            case EAST: {
                return Optional.of(BlockFace.WEST);
            }
            case WEST: {
                return Optional.of(BlockFace.EAST);
            }
            case NORTH: {
                return Optional.of(BlockFace.SOUTH);
            }
            case SOUTH: {
                return Optional.of(BlockFace.NORTH);
            }
        }
        return Optional.empty();
    }

    private void start() {
        Task.EXECUTOR.execute(() -> {
            Collection signs = (Collection)ExecutorAPI.getInstance().getSyncAPI().getDatabaseSyncAPI().find("reformcloud_internal_db_signs", "signs", null, k -> (Collection)k.get("signs", (TypeToken)new TypeToken<Collection<CloudSign>>(){}));
            if (signs == null) {
                return;
            }
            this.cachedSigns.addAll(signs);
            ExecutorAPI.getInstance().getSyncAPI().getProcessSyncAPI().getAllProcesses().forEach(this::handleProcessStart);
            this.runTasks();
        });
    }

    private void restartTask() {
        if (this.taskID != -1) {
            Bukkit.getScheduler().cancelTask(this.taskID);
        }
        this.runTasks();
    }

    private void runTasks() {
        this.taskID = Bukkit.getScheduler().runTaskTimerAsynchronously(this.plugin, this::updateAllSigns, 0L, 20L * this.config.getUpdateInterval()).getTaskId();
    }

    private boolean isCurrent(ProcessInformation processInformation) {
        ProcessInformation info = ExecutorAPI.getInstance().getSyncAPI().getProcessSyncAPI().getThisProcessInformation();
        return info != null && info.getProcessUniqueID().equals(processInformation.getProcessUniqueID());
    }

    private SignLayout getSelfLayout() {
        return LayoutUtil.getLayoutFor(ExecutorAPI.getInstance().getSyncAPI().getProcessSyncAPI().getThisProcessInformation().getProcessGroup().getName(), this.config).orElseThrow(() -> new RuntimeException("No sign config present for context global or current group"));
    }

    public static BukkitSignSystemAdapter getInstance() {
        return instance;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }
}

