/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.signs.sponge.adapter;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.block.tileentity.Sign;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.mutable.block.DirectionalData;
import org.spongepowered.api.data.manipulator.mutable.tileentity.SignData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.FormattingCodeTextSerializer;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.world.Location;
import systems.reformcloud.reformcloud2.executor.api.common.ExecutorAPI;
import systems.reformcloud.reformcloud2.executor.api.common.network.channel.handler.NetworkHandler;
import systems.reformcloud.reformcloud2.executor.api.common.network.channel.manager.DefaultChannelManager;
import systems.reformcloud.reformcloud2.executor.api.common.network.packet.Packet;
import systems.reformcloud.reformcloud2.executor.api.common.process.ProcessInformation;
import systems.reformcloud.reformcloud2.executor.api.common.process.ProcessState;
import systems.reformcloud.reformcloud2.executor.api.common.utility.list.Links;
import systems.reformcloud.reformcloud2.executor.api.common.utility.task.Task;
import systems.reformcloud.reformcloud2.signs.listener.CloudListener;
import systems.reformcloud.reformcloud2.signs.packets.api.in.APIPacketInCreateSign;
import systems.reformcloud.reformcloud2.signs.packets.api.in.APIPacketInDeleteSign;
import systems.reformcloud.reformcloud2.signs.packets.api.in.APIPacketInReloadConfig;
import systems.reformcloud.reformcloud2.signs.packets.api.out.APIPacketOutCreateSign;
import systems.reformcloud.reformcloud2.signs.packets.api.out.APIPacketOutDeleteSign;
import systems.reformcloud.reformcloud2.signs.sponge.adapter.SpongeSignConverter;
import systems.reformcloud.reformcloud2.signs.sponge.command.SpongeCommandSigns;
import systems.reformcloud.reformcloud2.signs.sponge.listener.SpongeListener;
import systems.reformcloud.reformcloud2.signs.util.LayoutUtil;
import systems.reformcloud.reformcloud2.signs.util.PlaceHolderUtil;
import systems.reformcloud.reformcloud2.signs.util.SignSystemAdapter;
import systems.reformcloud.reformcloud2.signs.util.converter.SignConverter;
import systems.reformcloud.reformcloud2.signs.util.sign.CloudLocation;
import systems.reformcloud.reformcloud2.signs.util.sign.CloudSign;
import systems.reformcloud.reformcloud2.signs.util.sign.config.SignConfig;
import systems.reformcloud.reformcloud2.signs.util.sign.config.SignLayout;
import systems.reformcloud.reformcloud2.signs.util.sign.config.SignSubLayout;

public class SpongeSignSystemAdapter
implements SignSystemAdapter<Sign> {
    private static SpongeSignSystemAdapter instance;
    private static final Map<String, BlockType> BLOCK_TYPES;
    private final List<CloudSign> cachedSigns = new LinkedList<CloudSign>();
    private final Object plugin;
    private SignConfig config;
    private UUID taskID;
    private Map<UUID, ProcessInformation> notAssigned = new ConcurrentHashMap<UUID, ProcessInformation>();
    private final AtomicInteger[] counter = new AtomicInteger[]{new AtomicInteger(-1), new AtomicInteger(-1), new AtomicInteger(-1), new AtomicInteger(-1), new AtomicInteger(-1), new AtomicInteger(-1)};

    public SpongeSignSystemAdapter(Object plugin, SignConfig config) {
        instance = this;
        SignSystemAdapter.instance.set(instance);
        this.plugin = plugin;
        this.config = config;
        ExecutorAPI.getInstance().getEventManager().registerListener((Object)new CloudListener());
        Sponge.getEventManager().registerListeners(plugin, (Object)new SpongeListener());
        ExecutorAPI.getInstance().getPacketHandler().registerNetworkHandlers(new NetworkHandler[]{new APIPacketInCreateSign(), new APIPacketInDeleteSign(), new APIPacketInReloadConfig()});
        CommandSpec signs = CommandSpec.builder().description((Text)Text.of((String)"The default signs command of the cloud system")).permission("reformcloud.command.signs").arguments(new CommandElement[]{GenericArguments.optional((CommandElement)GenericArguments.string((Text)Text.of((String)"Execute type"))), GenericArguments.optional((CommandElement)GenericArguments.string((Text)Text.of((String)"Target group")))}).executor((CommandExecutor)new SpongeCommandSigns()).build();
        Sponge.getCommandManager().register(plugin, (CommandCallable)signs, new String[]{"signs"});
        this.start();
    }

    @Override
    public void handleProcessStart(@Nonnull ProcessInformation processInformation) {
        if (!processInformation.getTemplate().isServer()) {
            return;
        }
        if (this.isCurrent(processInformation)) {
            return;
        }
        this.assign(processInformation);
        this.updateAllSigns();
    }

    @Override
    public void handleProcessUpdate(@Nonnull ProcessInformation processInformation) {
        if (!processInformation.getTemplate().isServer()) {
            return;
        }
        if (this.isCurrent(processInformation)) {
            return;
        }
        this.updateAssign(processInformation);
        this.updateAllSigns();
    }

    @Override
    public void handleProcessStop(@Nonnull ProcessInformation processInformation) {
        if (!processInformation.getTemplate().isServer()) {
            return;
        }
        if (this.isCurrent(processInformation)) {
            return;
        }
        this.deleteAssignment(processInformation);
        this.updateAllSigns();
    }

    @Override
    @Nonnull
    public CloudSign createSign(@Nonnull Sign sign, @Nonnull String group) {
        CloudSign cloudSign = this.getSignConverter().to(sign, group);
        if (this.getSignAt(cloudSign.getLocation()) != null) {
            return cloudSign;
        }
        DefaultChannelManager.INSTANCE.get("Controller").ifPresent(e -> e.sendPacket((Packet)new APIPacketOutCreateSign(cloudSign)));
        return cloudSign;
    }

    @Override
    public void deleteSign(@Nonnull CloudLocation location) {
        Links.filterToReference(this.cachedSigns, e -> e.getLocation().equals(location)).ifPresent(e -> DefaultChannelManager.INSTANCE.get("Controller").ifPresent(s -> s.sendPacket((Packet)new APIPacketOutDeleteSign((CloudSign)e))));
    }

    @Override
    @Nullable
    public CloudSign getSignAt(@Nonnull CloudLocation location) {
        return (CloudSign)Links.filter(this.cachedSigns, e -> e.getLocation().equals(location));
    }

    @Override
    @Nonnull
    public SignConverter<Sign> getSignConverter() {
        return SpongeSignConverter.INSTANCE;
    }

    @Override
    public boolean canConnect(@Nonnull CloudSign cloudSign) {
        if (cloudSign.getCurrentTarget() == null || !cloudSign.getCurrentTarget().getNetworkInfo().isConnected()) {
            return false;
        }
        if (cloudSign.getCurrentTarget().getProcessGroup().getPlayerAccessConfiguration().isMaintenance()) {
            return this.getSelfLayout().isShowMaintenanceProcessesOnSigns();
        }
        return true;
    }

    @Override
    public void handleInternalSignCreate(@Nonnull CloudSign cloudSign) {
        this.cachedSigns.add(cloudSign);
        this.tryAssign();
        this.updateAllSigns();
    }

    @Override
    public void handleInternalSignDelete(@Nonnull CloudSign cloudSign) {
        Links.filterToReference(this.cachedSigns, e -> e.getLocation().equals(cloudSign.getLocation())).ifPresent(e -> {
            this.cachedSigns.remove(e);
            this.removeAssign((CloudSign)e);
            this.clearLines(this.getSignConverter().from((CloudSign)e));
            this.updateAllSigns();
        });
    }

    @Override
    public void handleSignConfigUpdate(@Nonnull SignConfig config) {
        this.config = config;
        this.restart();
    }

    private UUID repeat(Runnable runnable, long interval) {
        return Sponge.getScheduler().createTaskBuilder().execute(runnable).delayTicks(0L).intervalTicks(interval).submit(this.plugin).getUniqueId();
    }

    private boolean isCurrent(ProcessInformation processInformation) {
        ProcessInformation info = ExecutorAPI.getInstance().getSyncAPI().getProcessSyncAPI().getThisProcessInformation();
        return info != null && info.getProcessUniqueID().equals(processInformation.getProcessUniqueID());
    }

    private void assign(ProcessInformation processInformation) {
        for (CloudSign sign : this.cachedSigns) {
            if (sign.getCurrentTarget() != null || !sign.getGroup().equals(processInformation.getProcessGroup().getName())) continue;
            sign.setCurrentTarget(processInformation);
            this.notAssigned.remove(processInformation.getProcessUniqueID());
            return;
        }
        this.notAssigned.put(processInformation.getProcessUniqueID(), processInformation);
    }

    private void updateAssign(ProcessInformation newInfo) {
        for (CloudSign sign : this.cachedSigns) {
            if (sign.getCurrentTarget() == null || !sign.getCurrentTarget().getProcessUniqueID().equals(newInfo.getProcessUniqueID())) continue;
            sign.setCurrentTarget(newInfo);
            break;
        }
    }

    private void deleteAssignment(ProcessInformation processInformation) {
        for (CloudSign sign : this.cachedSigns) {
            if (sign.getCurrentTarget() == null || !sign.getCurrentTarget().getProcessUniqueID().equals(processInformation.getProcessUniqueID())) continue;
            sign.setCurrentTarget(null);
            return;
        }
        this.notAssigned.remove(processInformation.getProcessUniqueID());
    }

    private void tryAssign() {
        if (this.notAssigned.isEmpty()) {
            return;
        }
        this.notAssigned.values().forEach(this::assign);
    }

    private void removeAssign(CloudSign sign) {
        if (sign.getCurrentTarget() == null) {
            return;
        }
        this.notAssigned.put(sign.getCurrentTarget().getProcessUniqueID(), sign.getCurrentTarget());
        sign.setCurrentTarget(null);
        this.tryAssign();
    }

    private void clearLines(Sign sign) {
        if (sign == null) {
            return;
        }
        SignData signData = sign.getSignData();
        signData.setElement(0, (Object)Text.of());
        signData.setElement(1, (Object)Text.of());
        signData.setElement(2, (Object)Text.of());
        signData.setElement(3, (Object)Text.of());
        sign.offer((ValueContainer)signData);
    }

    private void updateAllSigns() {
        SignLayout layout = this.getSelfLayout();
        SignSubLayout searching = LayoutUtil.getNextAndCheckFor(layout.getSearchingLayouts(), this.counter[0]).orElseThrow(() -> new RuntimeException("Waiting layout for current group not present"));
        SignSubLayout maintenance = LayoutUtil.getNextAndCheckFor(layout.getMaintenanceLayout(), this.counter[5]).orElseThrow(() -> new RuntimeException("Waiting layout for current group not present"));
        SignSubLayout connecting = LayoutUtil.getNextAndCheckFor(layout.getWaitingForConnectLayout(), this.counter[1]).orElseThrow(() -> new RuntimeException("Connecting layout for current group not present"));
        SignSubLayout empty = LayoutUtil.getNextAndCheckFor(layout.getEmptyLayout(), this.counter[2]).orElseThrow(() -> new RuntimeException("Empty layout for current group not present"));
        SignSubLayout full = LayoutUtil.getNextAndCheckFor(layout.getFullLayout(), this.counter[4]).orElseThrow(() -> new RuntimeException("Empty layout for current group not present"));
        SignSubLayout online = LayoutUtil.getNextAndCheckFor(layout.getOnlineLayout(), this.counter[3]).orElseThrow(() -> new RuntimeException("Empty layout for current group not present"));
        this.cachedSigns.forEach(e -> {
            if (e.getCurrentTarget() == null) {
                this.updateSign((CloudSign)e, searching, null);
                return;
            }
            if (e.getCurrentTarget().getProcessState().equals((Object)ProcessState.INVISIBLE) || e.getCurrentTarget().getProcessState().equals((Object)ProcessState.STOPPED) || e.getCurrentTarget().getProcessState().equals((Object)ProcessState.STARTED) || e.getCurrentTarget().getProcessState().equals((Object)ProcessState.PREPARED)) {
                this.updateSign((CloudSign)e, searching, null);
                return;
            }
            if (e.getCurrentTarget().getProcessGroup().getPlayerAccessConfiguration().isMaintenance()) {
                if (layout.isShowMaintenanceProcessesOnSigns()) {
                    this.updateSign((CloudSign)e, maintenance, e.getCurrentTarget());
                    return;
                }
                this.updateSign((CloudSign)e, searching, null);
                return;
            }
            if (!e.getCurrentTarget().getNetworkInfo().isConnected()) {
                this.updateSign((CloudSign)e, connecting, e.getCurrentTarget());
                return;
            }
            if (e.getCurrentTarget().getOnlineCount() == 0) {
                this.updateSign((CloudSign)e, empty, e.getCurrentTarget());
                return;
            }
            if (e.getCurrentTarget().getOnlineCount() >= e.getCurrentTarget().getMaxPlayers()) {
                if (layout.isSearchingLayoutWhenFull()) {
                    this.updateSign((CloudSign)e, searching, null);
                    return;
                }
                this.updateSign((CloudSign)e, full, e.getCurrentTarget());
                return;
            }
            this.updateSign((CloudSign)e, online, e.getCurrentTarget());
        });
    }

    private void updateSign(CloudSign sign, SignSubLayout layout, ProcessInformation processInformation) {
        Sign sponge = this.getSignConverter().from(sign);
        if (sponge == null || layout.getLines() == null || layout.getLines().length != 4) {
            return;
        }
        SignData signData = sponge.getSignData();
        signData.setElement(0, (Object)this.replaceAll(layout.getLines()[0], sign.getGroup(), processInformation));
        signData.setElement(1, (Object)this.replaceAll(layout.getLines()[1], sign.getGroup(), processInformation));
        signData.setElement(2, (Object)this.replaceAll(layout.getLines()[2], sign.getGroup(), processInformation));
        signData.setElement(3, (Object)this.replaceAll(layout.getLines()[3], sign.getGroup(), processInformation));
        sponge.offer((ValueContainer)signData);
        this.changeBlockBehind(sponge, layout);
    }

    private void changeBlockBehind(Sign sign, SignSubLayout layout) {
        Optional directionalData = sign.getLocation().get(DirectionalData.class);
        if (!directionalData.isPresent()) {
            return;
        }
        DirectionalData data = (DirectionalData)directionalData.get();
        data.get(Keys.DIRECTION).ifPresent(e -> {
            Location blockRelative = sign.getLocation().getBlockRelative(e.getOpposite());
            BlockType blockType = BLOCK_TYPES.get(layout.getBlock());
            if (blockType == null) {
                return;
            }
            blockRelative.setBlockType(blockType);
        });
    }

    private Text replaceAll(String line, String group, ProcessInformation processInformation) {
        if (processInformation == null) {
            line = line.replace("%group%", group);
            return TextSerializers.FORMATTING_CODE.deserialize(line);
        }
        return PlaceHolderUtil.format(line, group, processInformation, arg_0 -> ((FormattingCodeTextSerializer)TextSerializers.FORMATTING_CODE).deserialize(arg_0));
    }

    private void start() {
        Task.EXECUTOR.execute(() -> {
            Collection signs = (Collection)ExecutorAPI.getInstance().getSyncAPI().getDatabaseSyncAPI().find("reformcloud_internal_db_signs", "signs", null, k -> (Collection)k.get("signs", (TypeToken)new TypeToken<Collection<CloudSign>>(){}));
            if (signs == null) {
                return;
            }
            this.cachedSigns.addAll(signs);
            ExecutorAPI.getInstance().getSyncAPI().getProcessSyncAPI().getAllProcesses().forEach(this::handleProcessStart);
            this.runTasks();
        });
    }

    private void runTasks() {
        this.taskID = this.repeat(this::updateAllSigns, this.config.getUpdateInterval() * 20L);
    }

    private void restart() {
        if (this.taskID != null) {
            Sponge.getScheduler().getTaskById(this.taskID).ifPresent(org.spongepowered.api.scheduler.Task::cancel);
        }
        this.runTasks();
    }

    private SignLayout getSelfLayout() {
        return LayoutUtil.getLayoutFor(ExecutorAPI.getInstance().getSyncAPI().getProcessSyncAPI().getThisProcessInformation().getProcessGroup().getName(), this.config).orElseThrow(() -> new RuntimeException("No sign config present for context global or current group"));
    }

    public static SpongeSignSystemAdapter getInstance() {
        return instance;
    }

    static {
        BLOCK_TYPES = new HashMap<String, BlockType>();
        Arrays.stream(BlockTypes.class.getDeclaredFields()).filter(e -> Modifier.isFinal(e.getModifiers()) && Modifier.isStatic(e.getModifiers())).forEach(e -> {
            try {
                BLOCK_TYPES.put(e.getName(), (BlockType)e.get(BlockTypes.class));
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        });
    }
}

