/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.signs.nukkit.adapter;

import cn.nukkit.Server;
import cn.nukkit.blockentity.BlockEntitySign;
import cn.nukkit.level.Location;
import cn.nukkit.math.Vector3;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import systems.reformcloud.reformcloud2.executor.api.common.ExecutorAPI;
import systems.reformcloud.reformcloud2.executor.api.common.base.Conditions;
import systems.reformcloud.reformcloud2.signs.util.converter.SignConverter;
import systems.reformcloud.reformcloud2.signs.util.sign.CloudLocation;
import systems.reformcloud.reformcloud2.signs.util.sign.CloudSign;

public class NukkitSignConverter
implements SignConverter<BlockEntitySign> {
    static final NukkitSignConverter INSTANCE = new NukkitSignConverter();

    @Override
    @Nullable
    public BlockEntitySign from(@Nonnull CloudSign cloudSign) {
        Location location = this.accumulate(cloudSign.getLocation());
        return location != null && location.getLevel().getBlockEntity((Vector3)location) instanceof BlockEntitySign ? (BlockEntitySign)location.getLevel().getBlockEntity((Vector3)location) : null;
    }

    @Override
    @Nonnull
    public CloudSign to(@Nonnull BlockEntitySign blockEntitySign, @Nonnull String group) {
        return new CloudSign(group, this.accumulate(blockEntitySign.getLocation().clone()));
    }

    @Override
    @Nonnull
    public CloudLocation to(@Nonnull BlockEntitySign blockEntitySign) {
        return this.accumulate(blockEntitySign.getLocation().clone());
    }

    private Location accumulate(CloudLocation cloudLocation) {
        if (Server.getInstance().getLevelByName(cloudLocation.getWorld()) == null) {
            return null;
        }
        return new Location(cloudLocation.getX(), cloudLocation.getY(), cloudLocation.getZ(), (double)cloudLocation.getYaw(), (double)cloudLocation.getPitch(), Server.getInstance().getLevelByName(cloudLocation.getWorld()));
    }

    private CloudLocation accumulate(Location location) {
        Conditions.isTrue((ExecutorAPI.getInstance().getSyncAPI().getProcessSyncAPI().getThisProcessInformation() != null ? 1 : 0) != 0);
        Conditions.isTrue((location.getLevel() != null ? 1 : 0) != 0);
        return new CloudLocation(location.getLevel().getName(), ExecutorAPI.getInstance().getSyncAPI().getProcessSyncAPI().getThisProcessInformation().getProcessGroup().getName(), location.getX(), location.getY(), location.getZ(), new BigDecimal(location.getYaw()).floatValue(), new BigDecimal(location.getPitch()).floatValue());
    }
}

