/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.signs.application;

import com.google.gson.reflect.TypeToken;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import systems.reformcloud.reformcloud2.executor.api.common.ExecutorAPI;
import systems.reformcloud.reformcloud2.executor.api.common.application.api.Application;
import systems.reformcloud.reformcloud2.executor.api.common.application.updater.ApplicationUpdateRepository;
import systems.reformcloud.reformcloud2.executor.api.common.configuration.JsonConfiguration;
import systems.reformcloud.reformcloud2.executor.api.common.network.channel.handler.NetworkHandler;
import systems.reformcloud.reformcloud2.executor.api.common.network.channel.manager.DefaultChannelManager;
import systems.reformcloud.reformcloud2.executor.api.common.network.packet.Packet;
import systems.reformcloud.reformcloud2.executor.api.common.utility.list.Links;
import systems.reformcloud.reformcloud2.executor.api.common.utility.system.SystemHelper;
import systems.reformcloud.reformcloud2.signs.application.ConfigHelper;
import systems.reformcloud.reformcloud2.signs.application.packets.in.PacketInCreateSign;
import systems.reformcloud.reformcloud2.signs.application.packets.in.PacketInDeleteSign;
import systems.reformcloud.reformcloud2.signs.application.packets.in.PacketInGetSignConfig;
import systems.reformcloud.reformcloud2.signs.application.packets.out.PacketOutReloadConfig;
import systems.reformcloud.reformcloud2.signs.application.updater.SignsUpdater;
import systems.reformcloud.reformcloud2.signs.util.sign.CloudSign;
import systems.reformcloud.reformcloud2.signs.util.sign.config.SignConfig;

public class ReformCloudApplication
extends Application {
    private static SignConfig signConfig;
    private static final ApplicationUpdateRepository REPOSITORY;

    public void onEnable() {
        if (!this.dataFolder().exists()) {
            SystemHelper.createDirectory((Path)this.dataFolder().toPath());
            ConfigHelper.createDefault(this.dataFolder().getPath());
        }
        ExecutorAPI.getInstance().getSyncAPI().getDatabaseSyncAPI().createDatabase("reformcloud_internal_db_signs");
        if (!ExecutorAPI.getInstance().getSyncAPI().getDatabaseSyncAPI().contains("reformcloud_internal_db_signs", "signs")) {
            ExecutorAPI.getInstance().getSyncAPI().getDatabaseSyncAPI().insert("reformcloud_internal_db_signs", "signs", null, new JsonConfiguration().add("signs", Collections.emptyList()));
        }
        ExecutorAPI.getInstance().getPacketHandler().registerNetworkHandlers(new NetworkHandler[]{new PacketInCreateSign(), new PacketInDeleteSign(), new PacketInGetSignConfig()});
        signConfig = ConfigHelper.read(this.dataFolder().getPath());
        DefaultChannelManager.INSTANCE.getAllSender().forEach(e -> e.sendPacket((Packet)new PacketOutReloadConfig(signConfig)));
    }

    public void onDisable() {
        ExecutorAPI.getInstance().getPacketHandler().unregisterNetworkHandlers(801);
        ExecutorAPI.getInstance().getPacketHandler().unregisterNetworkHandlers(802);
        ExecutorAPI.getInstance().getPacketHandler().unregisterNetworkHandlers(803);
    }

    @Nullable
    public ApplicationUpdateRepository getUpdateRepository() {
        return REPOSITORY;
    }

    public static SignConfig getSignConfig() {
        return signConfig;
    }

    public static void insert(CloudSign cloudSign) {
        Collection<CloudSign> signs = ReformCloudApplication.read();
        if (signs == null) {
            return;
        }
        signs.add(cloudSign);
        ReformCloudApplication.insert(signs);
    }

    public static void delete(CloudSign cloudSign) {
        Collection<CloudSign> signs = ReformCloudApplication.read();
        if (signs == null) {
            return;
        }
        Links.filterToReference(signs, e -> e.getLocation().equals(cloudSign.getLocation())).ifPresent(signs::remove);
        ReformCloudApplication.insert(signs);
    }

    private static Collection<CloudSign> read() {
        return (Collection)ExecutorAPI.getInstance().getSyncAPI().getDatabaseSyncAPI().find("reformcloud_internal_db_signs", "signs", null, k -> (Collection)k.get("signs", (TypeToken)new TypeToken<Collection<CloudSign>>(){}));
    }

    private static void insert(Collection<CloudSign> signs) {
        ExecutorAPI.getInstance().getSyncAPI().getDatabaseSyncAPI().update("reformcloud_internal_db_signs", "signs", new JsonConfiguration().add("signs", signs));
    }

    static {
        REPOSITORY = new SignsUpdater();
    }
}

