/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.signs.bukkit.adapter;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Sign;
import systems.reformcloud.reformcloud2.executor.api.common.ExecutorAPI;
import systems.reformcloud.reformcloud2.executor.api.common.base.Conditions;
import systems.reformcloud.reformcloud2.signs.util.converter.SignConverter;
import systems.reformcloud.reformcloud2.signs.util.sign.CloudLocation;
import systems.reformcloud.reformcloud2.signs.util.sign.CloudSign;

public class BukkitSignConverter
implements SignConverter<Sign> {
    static final BukkitSignConverter INSTANCE = new BukkitSignConverter();

    @Override
    @Nullable
    public Sign from(@Nonnull CloudSign cloudSign) {
        Location bukkit = this.accumulate(cloudSign.getLocation());
        return bukkit != null && bukkit.getBlock().getState() instanceof Sign ? (Sign)bukkit.getBlock().getState() : null;
    }

    @Override
    @Nonnull
    public CloudSign to(@Nonnull Sign sign, @Nonnull String group) {
        return new CloudSign(group, this.accumulate(sign.getLocation().clone()));
    }

    @Override
    @Nonnull
    public CloudLocation to(@Nonnull Sign sign) {
        return this.accumulate(sign.getLocation().clone());
    }

    private Location accumulate(CloudLocation location) {
        if (Bukkit.getWorld((String)location.getWorld()) == null) {
            return null;
        }
        return new Location(Bukkit.getWorld((String)location.getWorld()), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    private CloudLocation accumulate(Location location) {
        Conditions.isTrue((location.getWorld() != null ? 1 : 0) != 0);
        Conditions.isTrue((ExecutorAPI.getInstance().getSyncAPI().getProcessSyncAPI().getThisProcessInformation() != null ? 1 : 0) != 0);
        return new CloudLocation(location.getWorld().getName(), ExecutorAPI.getInstance().getSyncAPI().getProcessSyncAPI().getThisProcessInformation().getProcessGroup().getName(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }
}

