/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.proxy.velocity.listener;

import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.event.player.ServerConnectedEvent;
import com.velocitypowered.api.event.proxy.ProxyPingEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.ServerPing;
import java.util.Arrays;
import java.util.UUID;
import net.kyori.text.Component;
import net.kyori.text.TextComponent;
import net.kyori.text.serializer.legacy.LegacyComponentSerializer;
import org.jetbrains.annotations.NotNull;
import systems.reformcloud.reformcloud2.executor.api.api.API;
import systems.reformcloud.reformcloud2.executor.api.common.api.basic.events.ProcessUpdatedEvent;
import systems.reformcloud.reformcloud2.executor.api.common.event.handler.Listener;
import systems.reformcloud.reformcloud2.executor.api.common.process.ProcessInformation;
import systems.reformcloud.reformcloud2.proxy.ProxyConfigurationHandler;

public final class VelocityListener {
    private final ProxyServer proxyServer;

    public VelocityListener(@NotNull ProxyServer proxyServer) {
        this.proxyServer = proxyServer;
    }

    public static void initTab0(@NotNull Player player) {
        ProxyConfigurationHandler.getInstance().getCurrentTabListConfiguration().ifPresent(tabListConfiguration -> {
            TextComponent header = tabListConfiguration.getHeader() == null ? TextComponent.empty() : LegacyComponentSerializer.legacyLinking().deserialize(VelocityListener.replaceVelocityPlaceHolders(player, tabListConfiguration.getHeader()));
            TextComponent footer = tabListConfiguration.getFooter() == null ? TextComponent.empty() : LegacyComponentSerializer.legacyLinking().deserialize(VelocityListener.replaceVelocityPlaceHolders(player, tabListConfiguration.getFooter()));
            player.getTabList().setHeaderAndFooter((Component)header, (Component)footer);
        });
    }

    @NotNull
    private static String replaceVelocityPlaceHolders(@NotNull Player player, @NotNull String tablist) {
        tablist = tablist.replace("%player_server%", player.getCurrentServer().isPresent() ? ((ServerConnection)player.getCurrentServer().get()).getServerInfo().getName() : "").replace("%player_name%", player.getUsername()).replace("%player_unique_id%", player.getUniqueId().toString()).replace("%player_ping%", Long.toString(player.getPing()));
        return ProxyConfigurationHandler.getInstance().replaceTabListPlaceHolders(tablist);
    }

    @Subscribe
    public void handle(@NotNull ProxyPingEvent event) {
        ProxyConfigurationHandler.getInstance().getBestMessageOfTheDayConfiguration().ifPresent(motdConfiguration -> {
            ServerPing.Builder builder = event.getPing().asBuilder();
            String protocol = motdConfiguration.getProtocol() == null ? null : ProxyConfigurationHandler.getInstance().replaceMessageOfTheDayPlaceHolders(motdConfiguration.getProtocol());
            String[] players = motdConfiguration.getPlayerInfo() == null ? null : (String[])Arrays.stream(motdConfiguration.getPlayerInfo()).map(ProxyConfigurationHandler.getInstance()::replaceMessageOfTheDayPlaceHolders).toArray(String[]::new);
            String first = motdConfiguration.getFirstLine() == null ? "" : motdConfiguration.getFirstLine();
            String second = motdConfiguration.getSecondLine() == null ? "" : motdConfiguration.getSecondLine();
            String finalMotd = ProxyConfigurationHandler.getInstance().replaceMessageOfTheDayPlaceHolders(first + "\n" + second);
            ServerPing.SamplePlayer[] samplePlayers = new ServerPing.SamplePlayer[players == null ? 0 : players.length];
            if (players != null) {
                for (int i = 0; i < samplePlayers.length; ++i) {
                    samplePlayers[i] = new ServerPing.SamplePlayer(players[i], UUID.randomUUID());
                }
            }
            ProcessInformation info = API.getInstance().getCurrentProcessInformation();
            int max = info.getProcessDetail().getMaxPlayers();
            int online = info.getProcessPlayerManager().getOnlineCount();
            builder.description((Component)LegacyComponentSerializer.legacyLinking().deserialize(finalMotd)).maximumPlayers(max).onlinePlayers(online).build();
            if (players != null) {
                builder.clearSamplePlayers().samplePlayers(samplePlayers);
            }
            if (protocol != null) {
                builder.version(new ServerPing.Version(1, protocol));
            }
            event.setPing(builder.build());
        });
    }

    @Subscribe(order=PostOrder.LAST)
    public void handle(PostLoginEvent event) {
        this.initTab();
    }

    @Subscribe
    public void handle(DisconnectEvent event) {
        this.initTab();
    }

    @Subscribe
    public void handle(@NotNull ServerConnectedEvent event) {
        VelocityListener.initTab0(event.getPlayer());
    }

    @Listener
    public void handle(@NotNull ProcessUpdatedEvent event) {
        if (event.getProcessInformation().getProcessDetail().getProcessUniqueID().equals(API.getInstance().getCurrentProcessInformation().getProcessDetail().getProcessUniqueID())) {
            this.initTab();
        }
    }

    public void initTab() {
        this.proxyServer.getAllPlayers().forEach(VelocityListener::initTab0);
    }
}

