/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.proxy.defaults;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import systems.reformcloud.reformcloud2.executor.api.api.API;
import systems.reformcloud.reformcloud2.executor.api.common.CommonHelper;
import systems.reformcloud.reformcloud2.executor.api.common.ExecutorAPI;
import systems.reformcloud.reformcloud2.executor.api.common.event.Event;
import systems.reformcloud.reformcloud2.executor.api.common.process.ProcessInformation;
import systems.reformcloud.reformcloud2.executor.api.common.utility.thread.AbsoluteThread;
import systems.reformcloud.reformcloud2.proxy.ProxyConfiguration;
import systems.reformcloud.reformcloud2.proxy.ProxyConfigurationHandler;
import systems.reformcloud.reformcloud2.proxy.config.MotdConfiguration;
import systems.reformcloud.reformcloud2.proxy.config.TabListConfiguration;
import systems.reformcloud.reformcloud2.proxy.event.ProxyConfigurationUpdateEvent;

public abstract class AbstractProxyConfigurationHandler
extends ProxyConfigurationHandler {
    private final AtomicInteger[] atomicIntegers = new AtomicInteger[]{new AtomicInteger(0), new AtomicInteger(0), new AtomicInteger(0)};
    @Nullable
    private ProxyConfiguration proxyConfiguration;
    private MotdConfiguration currentMessageOfTheDayConfiguration;
    private MotdConfiguration currentMaintenanceMessageOfTheDayConfiguration;
    private TabListConfiguration currentTabListConfiguration;

    @Override
    @NotNull
    public ProxyConfigurationHandler enable() {
        this.startTasks();
        return this;
    }

    @Override
    @NotNull
    public Optional<ProxyConfiguration> getProxyConfiguration() {
        return Optional.ofNullable(this.proxyConfiguration);
    }

    @Override
    @NotNull
    public Optional<TabListConfiguration> getCurrentTabListConfiguration() {
        return Optional.ofNullable(this.currentTabListConfiguration);
    }

    @Override
    @NotNull
    public Optional<MotdConfiguration> getCurrentMessageOfTheDayConfiguration() {
        return Optional.ofNullable(this.currentMessageOfTheDayConfiguration);
    }

    @Override
    @NotNull
    public Optional<MotdConfiguration> getCurrentMaintenanceMessageOfTheDayConfiguration() {
        return Optional.ofNullable(this.currentMaintenanceMessageOfTheDayConfiguration);
    }

    @Override
    @NotNull
    public Optional<MotdConfiguration> getBestMessageOfTheDayConfiguration() {
        return API.getInstance().getCurrentProcessInformation().getProcessGroup().getPlayerAccessConfiguration().isMaintenance() ? this.getCurrentMaintenanceMessageOfTheDayConfiguration() : this.getCurrentMessageOfTheDayConfiguration();
    }

    @Override
    @NotNull
    public String replaceMessageOfTheDayPlaceHolders(@NotNull String messageOfTheDay) {
        ProcessInformation current = API.getInstance().getCurrentProcessInformation();
        messageOfTheDay = messageOfTheDay.replace("%proxy_name%", current.getProcessDetail().getName()).replace("%proxy_display_name%", current.getProcessDetail().getDisplayName()).replace("%proxy_unique_id%", current.getProcessDetail().getProcessUniqueID().toString()).replace("%proxy_id%", Integer.toString(current.getProcessDetail().getId())).replace("%proxy_online_players%", Integer.toString(current.getProcessPlayerManager().getOnlineCount())).replace("%proxy_max_players%", Integer.toString(current.getProcessDetail().getMaxPlayers())).replace("%proxy_group%", current.getProcessGroup().getName()).replace("%proxy_parent%", current.getProcessDetail().getParentName());
        return ProxyConfigurationHandler.translateAlternateColorCodes('&', messageOfTheDay);
    }

    @Override
    @NotNull
    public String replaceTabListPlaceHolders(@NotNull String tabList) {
        return this.replaceMessageOfTheDayPlaceHolders(tabList);
    }

    @Override
    public void handleProxyConfigUpdate(@NotNull ProxyConfiguration proxyConfiguration) {
        this.proxyConfiguration = proxyConfiguration;
        ExecutorAPI.getInstance().getEventManager().callEvent((Event)new ProxyConfigurationUpdateEvent(this.proxyConfiguration));
    }

    private void startTasks() {
        CommonHelper.EXECUTOR.execute(() -> {
            while (!Thread.interrupted()) {
                if (this.proxyConfiguration == null || this.proxyConfiguration.getMotdDefaultConfig().isEmpty()) {
                    AbsoluteThread.sleep((long)500L);
                    continue;
                }
                int count = this.atomicIntegers[0].getAndIncrement();
                this.currentMessageOfTheDayConfiguration = this.proxyConfiguration.getMotdDefaultConfig().get(count);
                if (count >= this.proxyConfiguration.getMotdDefaultConfig().size() - 1) {
                    this.atomicIntegers[0].set(0);
                }
                AbsoluteThread.sleep((TimeUnit)TimeUnit.SECONDS, (long)this.currentMessageOfTheDayConfiguration.getWaitUntilNextInSeconds());
            }
        });
        CommonHelper.EXECUTOR.execute(() -> {
            while (!Thread.interrupted()) {
                if (this.proxyConfiguration == null || this.proxyConfiguration.getMotdMaintenanceConfig().isEmpty()) {
                    AbsoluteThread.sleep((long)500L);
                    continue;
                }
                int count = this.atomicIntegers[1].getAndIncrement();
                this.currentMaintenanceMessageOfTheDayConfiguration = this.proxyConfiguration.getMotdMaintenanceConfig().get(count);
                if (count >= this.proxyConfiguration.getMotdMaintenanceConfig().size() - 1) {
                    this.atomicIntegers[1].set(0);
                }
                AbsoluteThread.sleep((TimeUnit)TimeUnit.SECONDS, (long)this.currentMaintenanceMessageOfTheDayConfiguration.getWaitUntilNextInSeconds());
            }
        });
        CommonHelper.EXECUTOR.execute(() -> {
            while (!Thread.interrupted()) {
                if (this.proxyConfiguration == null || this.proxyConfiguration.getTabListConfigurations().isEmpty()) {
                    AbsoluteThread.sleep((long)500L);
                    continue;
                }
                int count = this.atomicIntegers[2].getAndIncrement();
                this.currentTabListConfiguration = this.proxyConfiguration.getTabListConfigurations().get(count);
                this.handleTabListChange();
                if (count >= this.proxyConfiguration.getTabListConfigurations().size() - 1) {
                    this.atomicIntegers[2].set(0);
                }
                AbsoluteThread.sleep((TimeUnit)TimeUnit.SECONDS, (long)this.currentTabListConfiguration.getWaitUntilNextInSeconds());
            }
        });
    }
}

