/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.proxy.bungeecord.listener;

import java.util.Arrays;
import java.util.UUID;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.event.ProxyPingEvent;
import net.md_5.bungee.api.event.ServerSwitchEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;
import org.jetbrains.annotations.NotNull;
import systems.reformcloud.reformcloud2.executor.api.api.API;
import systems.reformcloud.reformcloud2.executor.api.common.api.basic.events.ProcessUpdatedEvent;
import systems.reformcloud.reformcloud2.executor.api.common.process.ProcessInformation;
import systems.reformcloud.reformcloud2.proxy.ProxyConfigurationHandler;

public final class BungeeCordListener
implements Listener {
    private static final BaseComponent[] EMPTY = TextComponent.fromLegacyText((String)"");

    private static void initTab() {
        ProxyServer.getInstance().getPlayers().forEach(BungeeCordListener::initTab0);
    }

    public static void initTab0(@NotNull ProxiedPlayer player) {
        ProxyConfigurationHandler.getInstance().getCurrentTabListConfiguration().ifPresent(tabListConfiguration -> {
            BaseComponent[] header = tabListConfiguration.getHeader() == null ? EMPTY : TextComponent.fromLegacyText((String)BungeeCordListener.replaceBungeeCordPlaceHolders(player, tabListConfiguration.getHeader()));
            BaseComponent[] footer = tabListConfiguration.getFooter() == null ? EMPTY : TextComponent.fromLegacyText((String)BungeeCordListener.replaceBungeeCordPlaceHolders(player, tabListConfiguration.getFooter()));
            player.setTabHeader(header, footer);
        });
    }

    @NotNull
    private static String replaceBungeeCordPlaceHolders(@NotNull ProxiedPlayer player, @NotNull String tablist) {
        tablist = tablist.replace("%player_server%", player.getServer() != null ? player.getServer().getInfo().getName() : "").replace("%player_name%", player.getName()).replace("%player_unique_id%", player.getUniqueId().toString()).replace("%player_ping%", Long.toString(player.getPing()));
        return ProxyConfigurationHandler.getInstance().replaceTabListPlaceHolders(tablist);
    }

    @EventHandler
    public void handle(@NotNull ProxyPingEvent event) {
        ProxyConfigurationHandler.getInstance().getBestMessageOfTheDayConfiguration().ifPresent(motdConfiguration -> {
            ServerPing serverPing = event.getResponse();
            String protocol = motdConfiguration.getProtocol() == null ? null : ProxyConfigurationHandler.getInstance().replaceMessageOfTheDayPlaceHolders(motdConfiguration.getProtocol());
            String[] players = motdConfiguration.getPlayerInfo() == null ? null : (String[])Arrays.stream(motdConfiguration.getPlayerInfo()).map(ProxyConfigurationHandler.getInstance()::replaceMessageOfTheDayPlaceHolders).toArray(String[]::new);
            String first = motdConfiguration.getFirstLine() == null ? "" : motdConfiguration.getFirstLine();
            String second = motdConfiguration.getSecondLine() == null ? "" : motdConfiguration.getSecondLine();
            String finalMotd = ProxyConfigurationHandler.getInstance().replaceMessageOfTheDayPlaceHolders(first + "\n" + second);
            ServerPing.PlayerInfo[] playerInfos = new ServerPing.PlayerInfo[players == null ? 0 : players.length];
            if (players != null) {
                for (int i = 0; i < playerInfos.length; ++i) {
                    playerInfos[i] = new ServerPing.PlayerInfo(players[i], UUID.randomUUID());
                }
            }
            ProcessInformation info = API.getInstance().getCurrentProcessInformation();
            int max = info.getProcessDetail().getMaxPlayers();
            int online = info.getProcessPlayerManager().getOnlineCount();
            if (players != null) {
                serverPing.setPlayers(new ServerPing.Players(max, online, playerInfos));
            }
            if (protocol != null) {
                serverPing.setVersion(new ServerPing.Protocol(protocol, 1));
            }
            serverPing.setDescriptionComponent((BaseComponent)new TextComponent(finalMotd));
            event.setResponse(serverPing);
        });
    }

    @EventHandler(priority=64)
    public void handle(PostLoginEvent event) {
        BungeeCordListener.initTab();
    }

    @EventHandler
    public void handle(PlayerDisconnectEvent event) {
        BungeeCordListener.initTab();
    }

    @EventHandler
    public void handle(@NotNull ServerSwitchEvent event) {
        BungeeCordListener.initTab0(event.getPlayer());
    }

    @systems.reformcloud.reformcloud2.executor.api.common.event.handler.Listener
    public void handle(@NotNull ProcessUpdatedEvent event) {
        if (event.getProcessInformation().getProcessDetail().getProcessUniqueID().equals(API.getInstance().getCurrentProcessInformation().getProcessDetail().getProcessUniqueID())) {
            BungeeCordListener.initTab();
        }
    }
}

