/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.proxy.application.updater;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jetbrains.annotations.Nullable;
import systems.reformcloud.reformcloud2.executor.api.common.application.updater.ApplicationRemoteUpdate;
import systems.reformcloud.reformcloud2.executor.api.common.application.updater.basic.BasicApplicationRemoteUpdate;
import systems.reformcloud.reformcloud2.executor.api.common.application.updater.basic.DefaultApplicationUpdateRepository;
import systems.reformcloud.reformcloud2.executor.api.common.utility.system.DownloadHelper;
import systems.reformcloud.reformcloud2.proxy.application.ProxyApplication;

public class ProxyAddonUpdater
extends DefaultApplicationUpdateRepository {
    private String newVersion;

    public void fetchOrigin() {
        DownloadHelper.openConnection((String)"https://internal.reformcloud.systems/version.properties", inputStream -> {
            try {
                Properties properties = new Properties();
                properties.load((InputStream)inputStream);
                this.newVersion = properties.getProperty("version");
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        });
    }

    public boolean isNewVersionAvailable() {
        return !ProxyApplication.self().getApplication().getApplicationConfig().getVersion().equals(this.newVersion);
    }

    @Nullable
    public ApplicationRemoteUpdate getUpdate() {
        if (!this.isNewVersionAvailable()) {
            return null;
        }
        return new BasicApplicationRemoteUpdate(this.newVersion, "https://dl.reformcloud.systems/addonsv2/reformcloud2-default-application-proxy-" + this.newVersion + ".jar");
    }
}

