/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.proxy;

import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import systems.reformcloud.reformcloud2.executor.api.common.ExecutorAPI;
import systems.reformcloud.reformcloud2.executor.api.common.event.Event;
import systems.reformcloud.reformcloud2.proxy.ProxyConfiguration;
import systems.reformcloud.reformcloud2.proxy.config.MotdConfiguration;
import systems.reformcloud.reformcloud2.proxy.config.TabListConfiguration;
import systems.reformcloud.reformcloud2.proxy.event.ProxyConfigurationHandlerSetupEvent;

public abstract class ProxyConfigurationHandler {
    private static ProxyConfigurationHandler instance;

    @NotNull
    public static ProxyConfigurationHandler getInstance() {
        return Objects.requireNonNull(instance, "The proxy config handler is configured yet");
    }

    @ApiStatus.Internal
    public static void setup() {
        ProxyConfigurationHandlerSetupEvent setupEvent = new ProxyConfigurationHandlerSetupEvent();
        ExecutorAPI.getInstance().getEventManager().callEvent((Event)setupEvent);
        instance = setupEvent.getProxyConfigurationHandler().enable();
    }

    @NotNull
    public static String translateAlternateColorCodes(char altColorChar, @NotNull String textToTranslate) {
        char[] b = textToTranslate.toCharArray();
        for (int i = 0; i < b.length - 1; ++i) {
            if (b[i] != altColorChar || "0123456789AaBbCcDdEeFfKkLlMmNnOoRr".indexOf(b[i + 1]) <= -1) continue;
            b[i] = 167;
            b[i + 1] = Character.toLowerCase(b[i + 1]);
        }
        return new String(b);
    }

    @NotNull
    @ApiStatus.Internal
    public abstract ProxyConfigurationHandler enable();

    @NotNull
    public abstract Optional<ProxyConfiguration> getProxyConfiguration();

    @NotNull
    public abstract Optional<TabListConfiguration> getCurrentTabListConfiguration();

    @NotNull
    public abstract Optional<MotdConfiguration> getCurrentMessageOfTheDayConfiguration();

    @NotNull
    public abstract Optional<MotdConfiguration> getCurrentMaintenanceMessageOfTheDayConfiguration();

    @NotNull
    public abstract Optional<MotdConfiguration> getBestMessageOfTheDayConfiguration();

    public abstract void handleTabListChange();

    @NotNull
    public abstract String replaceMessageOfTheDayPlaceHolders(@NotNull String var1);

    @NotNull
    public abstract String replaceTabListPlaceHolders(@NotNull String var1);

    @ApiStatus.Internal
    public abstract void handleProxyConfigUpdate(@NotNull ProxyConfiguration var1);
}

