/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.proxy.application;

import org.jetbrains.annotations.Nullable;
import systems.reformcloud.reformcloud2.executor.api.ExecutorAPI;
import systems.reformcloud.reformcloud2.executor.api.application.api.Application;
import systems.reformcloud.reformcloud2.executor.api.application.updater.ApplicationUpdateRepository;
import systems.reformcloud.reformcloud2.executor.api.event.EventManager;
import systems.reformcloud.reformcloud2.executor.api.network.channel.NetworkChannel;
import systems.reformcloud.reformcloud2.executor.api.network.channel.manager.ChannelManager;
import systems.reformcloud.reformcloud2.executor.api.network.packet.PacketProvider;
import systems.reformcloud.reformcloud2.proxy.application.ConfigHelper;
import systems.reformcloud.reformcloud2.proxy.application.listener.ProcessInclusionHandler;
import systems.reformcloud.reformcloud2.proxy.application.network.PacketRequestConfig;
import systems.reformcloud.reformcloud2.proxy.application.updater.ProxyAddonUpdater;
import systems.reformcloud.reformcloud2.proxy.network.PacketProxyConfigUpdate;

public class ProxyApplication
extends Application {
    private static final ApplicationUpdateRepository REPOSITORY = new ProxyAddonUpdater();
    private static ProxyApplication instance;

    public static ProxyApplication getInstance() {
        return instance;
    }

    public void onLoad() {
        instance = this;
        ConfigHelper.init(this.getDataFolder());
        ((EventManager)ExecutorAPI.getInstance().getServiceRegistry().getProviderUnchecked(EventManager.class)).registerListener((Object)new ProcessInclusionHandler());
        ((PacketProvider)ExecutorAPI.getInstance().getServiceRegistry().getProviderUnchecked(PacketProvider.class)).registerPacket(PacketRequestConfig.class);
        for (NetworkChannel registeredChannel : ((ChannelManager)ExecutorAPI.getInstance().getServiceRegistry().getProviderUnchecked(ChannelManager.class)).getRegisteredChannels()) {
            if (!registeredChannel.isAuthenticated()) continue;
            registeredChannel.sendPacket((Object)new PacketProxyConfigUpdate(ConfigHelper.getProxyConfiguration()));
        }
    }

    public void onDisable() {
        ((PacketProvider)ExecutorAPI.getInstance().getServiceRegistry().getProviderUnchecked(PacketProvider.class)).unregisterPacket(6006);
    }

    @Nullable
    public ApplicationUpdateRepository getUpdateRepository() {
        return REPOSITORY;
    }
}

