/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.proxy.velocity.listener;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.event.player.ServerConnectedEvent;
import com.velocitypowered.api.event.proxy.ProxyPingEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.ServerPing;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.kyori.text.Component;
import net.kyori.text.TextComponent;
import systems.reformcloud.reformcloud2.executor.api.common.ExecutorAPI;
import systems.reformcloud.reformcloud2.executor.api.common.api.basic.events.ProcessUpdatedEvent;
import systems.reformcloud.reformcloud2.executor.api.common.event.handler.Listener;
import systems.reformcloud.reformcloud2.executor.api.common.process.ProcessInformation;
import systems.reformcloud.reformcloud2.executor.api.common.utility.task.Task;
import systems.reformcloud.reformcloud2.executor.api.common.utility.thread.AbsoluteThread;
import systems.reformcloud.reformcloud2.proxy.config.MotdConfiguration;
import systems.reformcloud.reformcloud2.proxy.config.TabListConfiguration;
import systems.reformcloud.reformcloud2.proxy.plugin.PluginConfigHandler;
import systems.reformcloud.reformcloud2.proxy.velocity.VelocityPlugin;

public class VelocityListener {
    private static final AtomicInteger[] ATOMIC_INTEGERS = new AtomicInteger[]{new AtomicInteger(0), new AtomicInteger(0), new AtomicInteger(0)};

    public VelocityListener() {
        Task.EXECUTOR.execute(() -> {
            while (!Thread.interrupted()) {
                if (PluginConfigHandler.getConfiguration().getTabListConfigurations().isEmpty()) {
                    return;
                }
                if (PluginConfigHandler.getConfiguration().getTabListConfigurations().size() == 1) {
                    return;
                }
                if (PluginConfigHandler.getConfiguration().getTabListConfigurations().size() <= ATOMIC_INTEGERS[0].get()) {
                    ATOMIC_INTEGERS[0].set(0);
                    VelocityListener.initTab();
                    AbsoluteThread.sleep((long)TimeUnit.SECONDS.toMillis(VelocityListener.getCurrentTabConfig().getWaitUntilNextInSeconds()));
                    continue;
                }
                VelocityListener.initTab();
                AbsoluteThread.sleep((long)TimeUnit.SECONDS.toMillis(VelocityListener.getCurrentTabConfig().getWaitUntilNextInSeconds()));
                ATOMIC_INTEGERS[0].incrementAndGet();
            }
        });
        Task.EXECUTOR.execute(() -> {
            while (!Thread.interrupted()) {
                if (PluginConfigHandler.getConfiguration().getMotdDefaultConfig().isEmpty()) {
                    return;
                }
                if (PluginConfigHandler.getConfiguration().getMotdDefaultConfig().size() == 1) {
                    return;
                }
                if (PluginConfigHandler.getConfiguration().getMotdDefaultConfig().size() <= ATOMIC_INTEGERS[1].get()) {
                    ATOMIC_INTEGERS[1].set(0);
                    AbsoluteThread.sleep((long)TimeUnit.SECONDS.toMillis(VelocityListener.getDefaultConfig().getWaitUntilNextInSeconds()));
                    continue;
                }
                AbsoluteThread.sleep((long)TimeUnit.SECONDS.toMillis(VelocityListener.getDefaultConfig().getWaitUntilNextInSeconds()));
                ATOMIC_INTEGERS[1].incrementAndGet();
            }
        });
        Task.EXECUTOR.execute(() -> {
            while (!Thread.interrupted()) {
                if (PluginConfigHandler.getConfiguration().getMotdMaintenanceConfig().isEmpty()) {
                    return;
                }
                if (PluginConfigHandler.getConfiguration().getMotdMaintenanceConfig().size() == 1) {
                    return;
                }
                if (PluginConfigHandler.getConfiguration().getMotdMaintenanceConfig().size() <= ATOMIC_INTEGERS[2].get()) {
                    ATOMIC_INTEGERS[2].set(0);
                    AbsoluteThread.sleep((long)TimeUnit.SECONDS.toMillis(VelocityListener.getMaintenanceConfig().getWaitUntilNextInSeconds()));
                    continue;
                }
                AbsoluteThread.sleep((long)TimeUnit.SECONDS.toMillis(VelocityListener.getMaintenanceConfig().getWaitUntilNextInSeconds()));
                ATOMIC_INTEGERS[2].incrementAndGet();
            }
        });
    }

    @Subscribe
    public void handle(ProxyPingEvent event) {
        ServerPing.Builder builder = event.getPing().asBuilder();
        MotdConfiguration current = VelocityListener.getCurrentMotdConfig();
        String[] players = VelocityListener.replaceAll(current.getPlayerInfo() == null ? new String[]{} : current.getPlayerInfo());
        String protocol = VelocityListener.replaceMotdString(current.getProtocol() == null ? "" : current.getProtocol());
        String first = current.getFirstLine() == null ? "" : current.getFirstLine();
        String second = current.getSecondLine() == null ? "" : current.getSecondLine();
        String finalMotd = VelocityListener.replaceMotdString(first + "\n" + second);
        ServerPing.SamplePlayer[] samplePlayers = new ServerPing.SamplePlayer[players.length];
        for (int i = 0; i < samplePlayers.length; ++i) {
            samplePlayers[i] = new ServerPing.SamplePlayer(players[i], UUID.randomUUID());
        }
        ProcessInformation info = ExecutorAPI.getInstance().getSyncAPI().getProcessSyncAPI().getThisProcessInformation();
        int max = info == null ? 0 : info.getMaxPlayers();
        int online = info == null ? 0 : info.getOnlineCount();
        ServerPing result = builder.clearMods().description((Component)TextComponent.of((String)finalMotd)).clearSamplePlayers().samplePlayers(samplePlayers).version(new ServerPing.Version(1, protocol)).maximumPlayers(max).onlinePlayers(online).build();
        event.setPing(result);
    }

    @Subscribe
    public void handle(PostLoginEvent event) {
        VelocityListener.initTab0(event.getPlayer());
    }

    @Subscribe
    public void handle(ServerConnectedEvent event) {
        VelocityListener.initTab0(event.getPlayer());
    }

    @Listener
    public void handle(ProcessUpdatedEvent event) {
        VelocityListener.initTab();
    }

    private static void initTab() {
        VelocityPlugin.proxyServer.getAllPlayers().forEach(VelocityListener::initTab0);
    }

    private static void initTab0(Player player) {
        TabListConfiguration current = VelocityListener.getCurrentTabConfig();
        TextComponent header = TextComponent.of((String)(current.getHeader() == null ? "" : VelocityListener.replaceTabList(player, current.getHeader())));
        TextComponent footer = TextComponent.of((String)(current.getFooter() == null ? "" : VelocityListener.replaceTabList(player, current.getFooter())));
        player.getTabList().setHeaderAndFooter((Component)header, (Component)footer);
    }

    public static TabListConfiguration getCurrentTabConfig() {
        return PluginConfigHandler.getConfiguration().getTabListConfigurations().get(ATOMIC_INTEGERS[0].get());
    }

    public static MotdConfiguration getCurrentMotdConfig() {
        boolean maintenance = ExecutorAPI.getInstance().getSyncAPI().getProcessSyncAPI().getThisProcessInformation() != null && ExecutorAPI.getInstance().getSyncAPI().getProcessSyncAPI().getThisProcessInformation().getProcessGroup().getPlayerAccessConfiguration().isMaintenance();
        return maintenance ? PluginConfigHandler.getConfiguration().getMotdMaintenanceConfig().get(ATOMIC_INTEGERS[2].get()) : PluginConfigHandler.getConfiguration().getMotdDefaultConfig().get(ATOMIC_INTEGERS[1].get());
    }

    private static MotdConfiguration getDefaultConfig() {
        return PluginConfigHandler.getConfiguration().getMotdDefaultConfig().get(ATOMIC_INTEGERS[1].get());
    }

    private static MotdConfiguration getMaintenanceConfig() {
        return PluginConfigHandler.getConfiguration().getMotdMaintenanceConfig().get(ATOMIC_INTEGERS[2].get());
    }

    private static String replaceMotdString(String text) {
        ProcessInformation current = ExecutorAPI.getInstance().getSyncAPI().getProcessSyncAPI().getThisProcessInformation();
        if (current == null) {
            return text;
        }
        return text.replace("%proxy_name%", current.getName()).replace("%proxy_display_name%", current.getDisplayName()).replace("%proxy_unique_id%", current.getProcessUniqueID().toString()).replace("%proxy_id%", Integer.toString(current.getId())).replace("%proxy_online_players%", Integer.toString(current.getOnlineCount())).replace("%proxy_max_players%", Integer.toString(current.getMaxPlayers())).replace("%proxy_group%", current.getProcessGroup().getName()).replace("%proxy_parent%", current.getParent());
    }

    private static String[] replaceAll(String[] in) {
        return (String[])Arrays.stream(in).map(VelocityListener::replaceMotdString).toArray(String[]::new);
    }

    private static String replaceTabList(Player player, String line) {
        ProcessInformation info = ExecutorAPI.getInstance().getSyncAPI().getProcessSyncAPI().getThisProcessInformation();
        int max = info == null ? 0 : info.getMaxPlayers();
        int online = info == null ? 0 : info.getOnlineCount();
        return line.replace("%player_server%", player.getCurrentServer().isPresent() ? ((ServerConnection)player.getCurrentServer().get()).getServerInfo().getName() : "").replace("%player_name%", player.getUsername()).replace("%player_unique_id%", player.getUniqueId().toString()).replace("%player_ping%", Long.toString(player.getPing())).replace("%proxy_online_count%", Integer.toString(online)).replace("%proxy_max_players%", Integer.toString(max));
    }
}

