/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.permissions.sponge.subject.base.user;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.SubjectData;
import systems.reformcloud.reformcloud2.permissions.PermissionManagement;
import systems.reformcloud.reformcloud2.permissions.objects.group.PermissionGroup;
import systems.reformcloud.reformcloud2.permissions.objects.user.PermissionUser;
import systems.reformcloud.reformcloud2.permissions.sponge.subject.AbstractSpongeSubjectData;
import systems.reformcloud.reformcloud2.permissions.sponge.subject.util.SubjectGroupPermissionCalculator;

public class SpongeSubjectData
extends AbstractSpongeSubjectData {
    private final UUID uniqueID;

    public SpongeSubjectData(@NotNull UUID user) {
        this.uniqueID = user;
    }

    @NotNull
    public Map<Set<Context>, Map<String, Boolean>> getAllPermissions() {
        return Collections.singletonMap(SubjectData.GLOBAL_CONTEXT, this.getPermissions());
    }

    @NotNull
    public Map<String, Boolean> getPermissions(@Nullable Set<Context> contexts) {
        return this.getPermissions();
    }

    private Map<String, Boolean> getPermissions() {
        HashMap<String, Boolean> out = new HashMap<String, Boolean>();
        PermissionUser user = PermissionManagement.getInstance().loadUser(this.uniqueID);
        user.getPermissionNodes().forEach(e -> {
            if (!e.isValid()) {
                return;
            }
            out.put(e.getActualPermission(), e.isSet());
        });
        user.getGroups().forEach(e -> {
            if (!e.isValid()) {
                return;
            }
            PermissionGroup group = PermissionManagement.getInstance().getGroup(e.getGroupName());
            if (group == null) {
                return;
            }
            out.putAll(this.getPermissionsOf(group));
            group.getSubGroups().forEach(g -> {
                PermissionGroup sub = PermissionManagement.getInstance().getGroup((String)g);
                if (sub == null) {
                    return;
                }
                out.putAll(this.getPermissionsOf(sub));
            });
        });
        return out;
    }

    private Map<String, Boolean> getPermissionsOf(PermissionGroup group) {
        return SubjectGroupPermissionCalculator.getPermissionsOf(group);
    }
}

