/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.permissions.sponge.subject.base.group;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.SubjectData;
import systems.reformcloud.reformcloud2.permissions.PermissionManagement;
import systems.reformcloud.reformcloud2.permissions.objects.group.PermissionGroup;
import systems.reformcloud.reformcloud2.permissions.sponge.subject.AbstractSpongeSubjectData;
import systems.reformcloud.reformcloud2.permissions.sponge.subject.util.SubjectGroupPermissionCalculator;

public class GroupSubjectData
extends AbstractSpongeSubjectData {
    private final String group;

    public GroupSubjectData(@NotNull String group) {
        this.group = group;
    }

    @NotNull
    public Map<Set<Context>, Map<String, Boolean>> getAllPermissions() {
        return Collections.singletonMap(SubjectData.GLOBAL_CONTEXT, this.getPermissions());
    }

    @NotNull
    public Map<String, Boolean> getPermissions(@Nullable Set<Context> contexts) {
        return this.getPermissions();
    }

    private Map<String, Boolean> getPermissions() {
        HashMap<String, Boolean> out = new HashMap<String, Boolean>();
        PermissionGroup permissionGroup = PermissionManagement.getInstance().getGroup(this.group);
        if (permissionGroup == null) {
            return out;
        }
        out.putAll(this.getPermissionsOf(permissionGroup));
        permissionGroup.getSubGroups().forEach(e -> {
            PermissionGroup sub = PermissionManagement.getInstance().getGroup((String)e);
            if (sub == null) {
                return;
            }
            out.putAll(this.getPermissionsOf(sub));
        });
        return out;
    }

    private Map<String, Boolean> getPermissionsOf(PermissionGroup group) {
        return SubjectGroupPermissionCalculator.getPermissionsOf(group);
    }
}

