/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.permissions.sponge.service;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.service.context.ContextCalculator;
import org.spongepowered.api.service.permission.PermissionDescription;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectCollection;
import org.spongepowered.api.service.permission.SubjectReference;
import systems.reformcloud.reformcloud2.permissions.sponge.collections.CollectionCatalog;
import systems.reformcloud.reformcloud2.permissions.sponge.description.SpongePermissionDescriptionBuilder;
import systems.reformcloud.reformcloud2.permissions.sponge.reference.SpongeSubjectReference;
import systems.reformcloud.reformcloud2.permissions.sponge.subject.util.SubjectDefaultData;

public class SpongePermissionService
implements PermissionService {
    public static final Map<String, PermissionDescription> DESCRIPTIONS = new ConcurrentHashMap<String, PermissionDescription>();
    private static final Map<String, SubjectCollection> LOADED = new HashMap<String, SubjectCollection>();
    private static SpongePermissionService instance;

    public SpongePermissionService() {
        instance = this;
    }

    public static SpongePermissionService getInstance() {
        return instance;
    }

    @NotNull
    public SubjectCollection getUserSubjects() {
        return CollectionCatalog.USER_COLLECTION;
    }

    @NotNull
    public SubjectCollection getGroupSubjects() {
        return CollectionCatalog.GROUP_COLLECTION;
    }

    @NotNull
    public Subject getDefaults() {
        return SubjectDefaultData.DEFAULT;
    }

    @NotNull
    public Predicate<String> getIdentifierValidityPredicate() {
        return s -> true;
    }

    @NotNull
    public CompletableFuture<SubjectCollection> loadCollection(@NotNull String identifier) {
        return CompletableFuture.completedFuture(LOADED.getOrDefault(identifier, CollectionCatalog.FACTORY_COLLECTION));
    }

    @NotNull
    public Optional<SubjectCollection> getCollection(@NotNull String identifier) {
        return Optional.ofNullable(this.loadCollection(identifier).join());
    }

    @NotNull
    public CompletableFuture<Boolean> hasCollection(@NotNull String identifier) {
        return CompletableFuture.completedFuture(this.getCollection(identifier).isPresent());
    }

    @NotNull
    public Map<String, SubjectCollection> getLoadedCollections() {
        return Collections.unmodifiableMap(LOADED);
    }

    @NotNull
    public CompletableFuture<Set<String>> getAllIdentifiers() {
        return CompletableFuture.completedFuture(LOADED.keySet());
    }

    @NotNull
    public SubjectReference newSubjectReference(@NotNull String collectionIdentifier, @NotNull String subjectIdentifier) {
        return new SpongeSubjectReference(this, collectionIdentifier, subjectIdentifier);
    }

    @NotNull
    public PermissionDescription.Builder newDescriptionBuilder(@NotNull Object plugin) {
        return new SpongePermissionDescriptionBuilder(this, Sponge.getPluginManager().fromInstance(plugin).orElse(null));
    }

    @NotNull
    public Optional<PermissionDescription> getDescription(@NotNull String permission) {
        return Optional.ofNullable(DESCRIPTIONS.get(permission));
    }

    @NotNull
    public Collection<PermissionDescription> getDescriptions() {
        return DESCRIPTIONS.values();
    }

    public void registerContextCalculator(@Nullable ContextCalculator<Subject> calculator) {
    }

    static {
        LOADED.put("commandblock", CollectionCatalog.COMMAND_BLOCK_COLLECTION);
        LOADED.put("system", CollectionCatalog.SYSTEM_COLLECTION);
        LOADED.put("user", CollectionCatalog.USER_COLLECTION);
        LOADED.put("defaults", CollectionCatalog.FACTORY_COLLECTION);
        LOADED.put("group", CollectionCatalog.GROUP_COLLECTION);
        LOADED.put("role-template", CollectionCatalog.GROUP_COLLECTION);
    }
}

