/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.permissions.packets;

import io.netty.channel.ChannelHandlerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import systems.reformcloud.reformcloud2.executor.api.ExecutorType;
import systems.reformcloud.reformcloud2.executor.api.common.ExecutorAPI;
import systems.reformcloud.reformcloud2.executor.api.common.network.SerializableObject;
import systems.reformcloud.reformcloud2.executor.api.common.network.challenge.ChallengeAuthHandler;
import systems.reformcloud.reformcloud2.executor.api.common.network.channel.NetworkChannelReader;
import systems.reformcloud.reformcloud2.executor.api.common.network.channel.PacketSender;
import systems.reformcloud.reformcloud2.executor.api.common.network.channel.manager.DefaultChannelManager;
import systems.reformcloud.reformcloud2.executor.api.common.network.data.ProtocolBuffer;
import systems.reformcloud.reformcloud2.executor.api.common.network.handler.ChannelReaderHelper;
import systems.reformcloud.reformcloud2.executor.api.common.network.packet.Packet;
import systems.reformcloud.reformcloud2.permissions.PermissionManagement;
import systems.reformcloud.reformcloud2.permissions.objects.user.PermissionUser;
import systems.reformcloud.reformcloud2.permissions.packets.util.PermissionAction;

public class PacketUserAction
extends Packet {
    private PermissionUser permissionUser;
    private PermissionAction permissionAction;

    public PacketUserAction() {
    }

    public PacketUserAction(PermissionUser permissionUser, PermissionAction permissionAction) {
        this.permissionUser = permissionUser;
        this.permissionAction = permissionAction;
    }

    public int getId() {
        return 8004;
    }

    public void handlePacketReceive(@NotNull NetworkChannelReader reader, @NotNull ChallengeAuthHandler authHandler, @NotNull ChannelReaderHelper parent, @Nullable PacketSender sender, @NotNull ChannelHandlerContext channel) {
        switch (this.permissionAction) {
            case DELETE: {
                PermissionManagement.getInstance().handleInternalUserDelete(this.permissionUser);
                if (ExecutorAPI.getInstance().getType() == ExecutorType.API) break;
                DefaultChannelManager.INSTANCE.getAllSender().forEach(e -> e.sendPacket((Object)new PacketUserAction(this.permissionUser, PermissionAction.DELETE)));
                break;
            }
            case UPDATE: {
                PermissionManagement.getInstance().handleInternalUserUpdate(this.permissionUser);
                if (ExecutorAPI.getInstance().getType() == ExecutorType.API) break;
                DefaultChannelManager.INSTANCE.getAllSender().forEach(e -> e.sendPacket((Object)new PacketUserAction(this.permissionUser, PermissionAction.UPDATE)));
                break;
            }
            case CREATE: {
                PermissionManagement.getInstance().handleInternalUserCreate(this.permissionUser);
                if (ExecutorAPI.getInstance().getType() == ExecutorType.API) break;
                DefaultChannelManager.INSTANCE.getAllSender().forEach(e -> e.sendPacket((Object)new PacketUserAction(this.permissionUser, PermissionAction.CREATE)));
            }
        }
    }

    public void write(@NotNull ProtocolBuffer buffer) {
        buffer.writeObject((SerializableObject)this.permissionUser);
        buffer.writeInt(this.permissionAction.ordinal());
    }

    public void read(@NotNull ProtocolBuffer buffer) {
        this.permissionUser = (PermissionUser)buffer.readObject(PermissionUser.class);
        this.permissionAction = PermissionAction.values()[buffer.readInt()];
    }
}

