/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.permissions.checks;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import systems.reformcloud.reformcloud2.executor.api.api.API;
import systems.reformcloud.reformcloud2.executor.api.common.process.ProcessInformation;
import systems.reformcloud.reformcloud2.permissions.nodes.PermissionNode;
import systems.reformcloud.reformcloud2.permissions.objects.group.PermissionGroup;
import systems.reformcloud.reformcloud2.permissions.objects.user.PermissionUser;

public final class WildcardCheck {
    private WildcardCheck() {
        throw new UnsupportedOperationException();
    }

    public static Boolean hasWildcardPermission(@NotNull PermissionGroup permissionGroup, @NotNull String perm) {
        Boolean hasPermission = WildcardCheck.hasPermission(permissionGroup.getPermissionNodes(), perm);
        if (hasPermission != null) {
            return hasPermission;
        }
        ProcessInformation current = API.getInstance().getCurrentProcessInformation();
        Collection<PermissionNode> currentGroupPerms = permissionGroup.getPerGroupPermissions().get(current.getProcessGroup().getName());
        if (currentGroupPerms == null || currentGroupPerms.isEmpty()) {
            return null;
        }
        return WildcardCheck.hasPermission(currentGroupPerms, perm);
    }

    @Nullable
    public static Boolean hasWildcardPermission(@NotNull PermissionUser permissionUser, @NotNull String perm) {
        Boolean hasPermission = WildcardCheck.hasPermission(permissionUser.getPermissionNodes(), perm);
        if (hasPermission != null) {
            return hasPermission;
        }
        ProcessInformation current = API.getInstance().getCurrentProcessInformation();
        Collection<PermissionNode> currentGroupPerms = permissionUser.getPerGroupPermissions().get(current.getProcessGroup().getName());
        if (currentGroupPerms == null || currentGroupPerms.isEmpty()) {
            return null;
        }
        return WildcardCheck.hasPermission(currentGroupPerms, perm);
    }

    @Nullable
    private static Boolean hasPermission(@NotNull Collection<PermissionNode> permissionNodes, @NotNull String permission) {
        for (PermissionNode permissionNode : permissionNodes) {
            String actual = permissionNode.getActualPermission();
            if (actual.length() <= 1 || !actual.endsWith("*") || !permission.startsWith(actual.substring(0, actual.length() - 1)) || !permissionNode.isValid()) continue;
            return permissionNode.isSet();
        }
        return null;
    }
}

