/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.permissions.checks;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import systems.reformcloud.reformcloud2.executor.api.api.API;
import systems.reformcloud.reformcloud2.executor.api.common.process.ProcessInformation;
import systems.reformcloud.reformcloud2.permissions.nodes.PermissionNode;
import systems.reformcloud.reformcloud2.permissions.objects.group.PermissionGroup;
import systems.reformcloud.reformcloud2.permissions.objects.user.PermissionUser;

public final class GeneralCheck {
    private GeneralCheck() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public static Boolean hasPermission(@NotNull PermissionGroup permissionGroup, @NotNull String perm) {
        Boolean hasPermission = GeneralCheck.has(permissionGroup, "*");
        if (hasPermission != null) {
            return hasPermission;
        }
        return GeneralCheck.has(permissionGroup, perm);
    }

    @Nullable
    public static Boolean hasPermission(@NotNull PermissionUser permissionUser, @NotNull String perm) {
        Boolean star = GeneralCheck.has(permissionUser, "*");
        if (star != null && star.booleanValue()) {
            return true;
        }
        return GeneralCheck.has(permissionUser, perm);
    }

    @Nullable
    private static Boolean has(@NotNull PermissionUser permissionUser, @NotNull String perm) {
        if (permissionUser.getPermissionNodes().stream().anyMatch(e -> e.getActualPermission().equals(perm) && e.isSet())) {
            return true;
        }
        ProcessInformation current = API.getInstance().getCurrentProcessInformation();
        if (!permissionUser.getPerGroupPermissions().containsKey(current.getProcessGroup().getName())) {
            return null;
        }
        Collection<PermissionNode> currentGroupPerms = permissionUser.getPerGroupPermissions().get(current.getProcessGroup().getName());
        if (currentGroupPerms.isEmpty()) {
            return null;
        }
        for (PermissionNode currentGroupPerm : currentGroupPerms) {
            if (!currentGroupPerm.getActualPermission().equals(perm)) continue;
            return currentGroupPerm.isSet();
        }
        return null;
    }

    @Nullable
    private static Boolean has(@NotNull PermissionGroup permissionGroup, @NotNull String perm) {
        if (permissionGroup.getPermissionNodes().stream().anyMatch(e -> e.getActualPermission().equals(perm) && e.isSet())) {
            return true;
        }
        ProcessInformation current = API.getInstance().getCurrentProcessInformation();
        if (!permissionGroup.getPerGroupPermissions().containsKey(current.getProcessGroup().getName())) {
            return null;
        }
        Collection<PermissionNode> currentGroupPerms = permissionGroup.getPerGroupPermissions().get(current.getProcessGroup().getName());
        if (currentGroupPerms.isEmpty()) {
            return null;
        }
        for (PermissionNode currentGroupPerm : currentGroupPerms) {
            if (!currentGroupPerm.getActualPermission().equals(perm)) continue;
            return currentGroupPerm.isSet();
        }
        return null;
    }
}

