/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.permissions.bukkit.vault;

import net.milkbowl.vault.permission.Permission;
import systems.reformcloud.reformcloud2.executor.api.common.utility.list.Streams;
import systems.reformcloud.reformcloud2.permissions.PermissionManagement;
import systems.reformcloud.reformcloud2.permissions.bukkit.vault.VaultUtil;
import systems.reformcloud.reformcloud2.permissions.nodes.NodeGroup;
import systems.reformcloud.reformcloud2.permissions.nodes.PermissionNode;
import systems.reformcloud.reformcloud2.permissions.objects.group.PermissionGroup;
import systems.reformcloud.reformcloud2.permissions.objects.user.PermissionUser;

public class PermissionVaultPermissionImplementation
extends Permission {
    private final PermissionManagement permissionManagement = PermissionManagement.getInstance();

    PermissionVaultPermissionImplementation() {
    }

    public String getName() {
        return "ReformCloud2BukkitPermissions";
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean hasSuperPermsCompat() {
        return true;
    }

    public boolean playerHas(String world, String player, String permission) {
        return VaultUtil.getUserFromName(player).map(user -> user.hasPermission(permission)).orElse(false);
    }

    public boolean playerAdd(String world, String player, String permission) {
        return VaultUtil.getUserFromName(player).map(user -> {
            this.permissionManagement.addUserPermission(user.getUniqueID(), PermissionNode.createNode(permission, -1L, true));
            return true;
        }).orElse(false);
    }

    public boolean playerRemove(String world, String player, String permission) {
        return VaultUtil.getUserFromName(player).map(user -> {
            PermissionNode node = (PermissionNode)Streams.filter(user.getPermissionNodes(), e -> e.getActualPermission().equals(permission));
            if (node == null) {
                return false;
            }
            user.getPermissionNodes().remove(node);
            this.permissionManagement.updateUser((PermissionUser)user);
            return true;
        }).orElse(false);
    }

    public boolean groupHas(String world, String group, String permission) {
        return this.permissionManagement.getPermissionGroup(group).map(g -> g.hasPermission(permission)).orElse(false);
    }

    public boolean groupAdd(String world, String group, String permission) {
        return this.permissionManagement.getPermissionGroup(group).map(g -> {
            this.permissionManagement.addGroupPermission((PermissionGroup)g, PermissionNode.createNode(permission, -1L, true));
            return true;
        }).orElse(false);
    }

    public boolean groupRemove(String world, String group, String permission) {
        return this.permissionManagement.getPermissionGroup(group).map(g -> {
            PermissionNode node = (PermissionNode)Streams.filter(g.getPermissionNodes(), e -> e.getActualPermission().equals(permission));
            if (node == null) {
                return false;
            }
            g.getPermissionNodes().remove(node);
            this.permissionManagement.updateGroup((PermissionGroup)g);
            return true;
        }).orElse(false);
    }

    public boolean playerInGroup(String world, String player, String group) {
        return VaultUtil.getUserFromName(player).map(permissionUser -> permissionUser.isInGroup(group)).orElse(false);
    }

    public boolean playerAddGroup(String world, String player, String group) {
        return VaultUtil.getUserFromName(player).map(p -> {
            boolean success = p.getGroups().add(new NodeGroup(System.currentTimeMillis(), -1L, group));
            if (success) {
                this.permissionManagement.updateUser((PermissionUser)p);
            }
            return success;
        }).orElse(false);
    }

    public boolean playerRemoveGroup(String world, String player, String group) {
        return VaultUtil.getUserFromName(player).map(permissionUser -> {
            NodeGroup nodeGroup = (NodeGroup)Streams.filter(permissionUser.getGroups(), e -> e.getGroupName().equals(group));
            if (nodeGroup == null) {
                return false;
            }
            permissionUser.getGroups().remove(nodeGroup);
            this.permissionManagement.updateUser((PermissionUser)permissionUser);
            return true;
        }).orElse(false);
    }

    public String[] getPlayerGroups(String world, String player) {
        return VaultUtil.getUserFromName(player).map(permissionUser -> (String[])permissionUser.getGroups().stream().map(NodeGroup::getGroupName).toArray(String[]::new)).orElse(new String[0]);
    }

    public String getPrimaryGroup(String world, String player) {
        return VaultUtil.getUserFromName(player).flatMap(PermissionUser::getHighestPermissionGroup).map(PermissionGroup::getName).orElse(null);
    }

    public String[] getGroups() {
        return (String[])this.permissionManagement.getPermissionGroups().stream().map(PermissionGroup::getName).toArray(String[]::new);
    }

    public boolean hasGroupSupport() {
        return true;
    }
}

