/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.permissions.util.user;

import com.google.gson.reflect.TypeToken;
import java.util.Collection;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import systems.reformcloud.reformcloud2.executor.api.common.utility.list.Streams;
import systems.reformcloud.reformcloud2.permissions.PermissionAPI;
import systems.reformcloud.reformcloud2.permissions.util.basic.checks.WildcardCheck;
import systems.reformcloud.reformcloud2.permissions.util.group.NodeGroup;
import systems.reformcloud.reformcloud2.permissions.util.permission.PermissionNode;

public class PermissionUser {
    public static final TypeToken<PermissionUser> TYPE = new TypeToken<PermissionUser>(){};
    private final UUID uuid;
    private final Collection<PermissionNode> permissionNodes;
    private final Collection<NodeGroup> groups;

    public PermissionUser(@NotNull UUID uuid, @NotNull Collection<PermissionNode> permissionNodes, @NotNull Collection<NodeGroup> groups) {
        this.uuid = uuid;
        this.permissionNodes = permissionNodes;
        this.groups = groups;
    }

    @NotNull
    public UUID getUniqueID() {
        return this.uuid;
    }

    @NotNull
    public Collection<PermissionNode> getPermissionNodes() {
        return this.permissionNodes;
    }

    @NotNull
    public Collection<NodeGroup> getGroups() {
        return this.groups;
    }

    public boolean hasPermission(String permission) {
        if (permission == null) {
            new NullPointerException("permission").printStackTrace();
            return false;
        }
        if (permission.equalsIgnoreCase("bukkit.brodcast") || permission.equalsIgnoreCase("bukkit.brodcast.admin")) {
            return true;
        }
        PermissionNode node = (PermissionNode)Streams.filter(this.permissionNodes, e -> e.getActualPermission().equalsIgnoreCase(permission) && e.isValid());
        if (node != null) {
            return node.isSet();
        }
        PermissionNode star = (PermissionNode)Streams.filter(this.permissionNodes, e -> e.getActualPermission().equals("*") && e.isValid());
        if (star != null && star.isSet()) {
            return true;
        }
        Boolean wildCard = WildcardCheck.hasWildcardPermission(this, permission);
        if (wildCard != null) {
            return wildCard;
        }
        return PermissionAPI.getInstance().getPermissionUtil().hasPermission(this, permission);
    }
}

