/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.permissions.util.group;

import com.google.gson.reflect.TypeToken;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import systems.reformcloud.reformcloud2.permissions.util.basic.checks.GeneralCheck;
import systems.reformcloud.reformcloud2.permissions.util.basic.checks.WildcardCheck;
import systems.reformcloud.reformcloud2.permissions.util.permission.PermissionNode;

public class PermissionGroup {
    public static final TypeToken<PermissionGroup> TYPE = new TypeToken<PermissionGroup>(){};
    private final Collection<PermissionNode> permissionNodes;
    private final Map<String, Collection<PermissionNode>> perGroupPermissions;
    private final Collection<String> subGroups;
    private final String name;
    private int priority;

    public PermissionGroup(@NotNull Collection<PermissionNode> permissionNodes, @NotNull Map<String, Collection<PermissionNode>> perGroupPermissions, @NotNull Collection<String> subGroups, @NotNull String name, int priority) {
        this.permissionNodes = permissionNodes;
        this.perGroupPermissions = perGroupPermissions;
        this.subGroups = subGroups;
        this.name = name;
        this.priority = priority;
    }

    @NotNull
    public Collection<PermissionNode> getPermissionNodes() {
        return this.permissionNodes;
    }

    @NotNull
    public Map<String, Collection<PermissionNode>> getPerGroupPermissions() {
        return this.perGroupPermissions;
    }

    @NotNull
    public Collection<String> getSubGroups() {
        return this.subGroups;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean hasPermission(@NotNull String perm) {
        if (WildcardCheck.hasWildcardPermission(this, perm)) {
            return true;
        }
        return GeneralCheck.hasPermission(this, perm);
    }
}

