/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.permissions.util.basic.checks;

import java.util.Collection;
import systems.reformcloud.reformcloud2.executor.api.api.API;
import systems.reformcloud.reformcloud2.executor.api.common.process.ProcessInformation;
import systems.reformcloud.reformcloud2.permissions.util.group.PermissionGroup;
import systems.reformcloud.reformcloud2.permissions.util.permission.PermissionNode;

public class GeneralCheck {
    public static boolean hasPermission(PermissionGroup permissionGroup, String perm) {
        if (GeneralCheck.has(permissionGroup, "*")) {
            return true;
        }
        return GeneralCheck.has(permissionGroup, perm);
    }

    private static boolean has(PermissionGroup permissionGroup, String perm) {
        if (permissionGroup.getPermissionNodes().stream().anyMatch(e -> e.getActualPermission().equals(perm) && e.isSet())) {
            return true;
        }
        ProcessInformation current = API.getInstance().getCurrentProcessInformation();
        if (!permissionGroup.getPerGroupPermissions().containsKey(current.getProcessGroup().getName())) {
            return false;
        }
        Collection<PermissionNode> currentGroupPerms = permissionGroup.getPerGroupPermissions().get(current.getProcessGroup().getName());
        if (currentGroupPerms.isEmpty()) {
            return false;
        }
        for (PermissionNode currentGroupPerm : currentGroupPerms) {
            if (!currentGroupPerm.getActualPermission().equals(perm)) continue;
            return currentGroupPerm.isSet();
        }
        return false;
    }
}

