/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.permissions.sponge.reference;

import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectCollection;
import org.spongepowered.api.service.permission.SubjectReference;

public class SpongeSubjectReference
implements SubjectReference {
    private final PermissionService service;
    private final String collection;
    private final String id;
    private Subject cache;

    public SpongeSubjectReference(@NotNull PermissionService service, @NotNull String collection, @NotNull String id) {
        this.collection = collection;
        this.id = id;
        this.service = service;
    }

    @NotNull
    public String getCollectionIdentifier() {
        return this.collection;
    }

    @NotNull
    public String getSubjectIdentifier() {
        return this.id;
    }

    @NotNull
    public CompletableFuture<Subject> resolve() {
        if (this.cache == null) {
            SubjectCollection subjectCollection = (SubjectCollection)this.service.getCollection(this.collection).orElseThrow(() -> new IllegalArgumentException("Collection not loaded"));
            this.cache = (Subject)subjectCollection.loadSubject(this.id).join();
        }
        return CompletableFuture.completedFuture(this.cache);
    }
}

