/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.permissions.sponge.collections;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.context.Contextual;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectCollection;
import org.spongepowered.api.service.permission.SubjectReference;
import org.spongepowered.api.util.Tristate;

public abstract class DefaultSubjectCollection
implements SubjectCollection {
    private final String type;
    protected final PermissionService service;

    public DefaultSubjectCollection(String type, PermissionService service) {
        this.type = type;
        this.service = service;
    }

    @NotNull
    protected abstract Subject load(String var1);

    @NotNull
    public String getIdentifier() {
        return this.type;
    }

    @NotNull
    public Predicate<String> getIdentifierValidityPredicate() {
        return s -> true;
    }

    @NotNull
    public SubjectReference newSubjectReference(@NotNull String subjectIdentifier) {
        return this.service.newSubjectReference(this.type, subjectIdentifier);
    }

    @NotNull
    public CompletableFuture<Subject> loadSubject(@NotNull String identifier) {
        return CompletableFuture.completedFuture(this.load(identifier));
    }

    @NotNull
    public Optional<Subject> getSubject(@NotNull String identifier) {
        return Optional.of(this.load(identifier));
    }

    @NotNull
    public CompletableFuture<Map<String, Subject>> loadSubjects(@NotNull Set<String> identifiers) {
        ConcurrentHashMap ref = new ConcurrentHashMap();
        identifiers.forEach(id -> ref.put(id, this.load((String)id)));
        return CompletableFuture.completedFuture(ref);
    }

    @NotNull
    public Map<Subject, Boolean> getLoadedWithPermission(@NotNull String permission) {
        return this.getLoadedWithPermission(null, permission);
    }

    @NotNull
    public Map<Subject, Boolean> getLoadedWithPermission(@Nullable Set<Context> contexts, @NotNull String permission) {
        ConcurrentHashMap<Subject, Boolean> out = new ConcurrentHashMap<Subject, Boolean>();
        this.getLoadedSubjects().forEach(e -> {
            Tristate tristate = e.getPermissionValue(contexts == null ? e.getActiveContexts() : contexts, permission);
            if (tristate.equals((Object)Tristate.UNDEFINED)) {
                return;
            }
            out.put((Subject)e, tristate.asBoolean());
        });
        return out;
    }

    @NotNull
    public CompletableFuture<Map<SubjectReference, Boolean>> getAllWithPermission(@NotNull String permission) {
        return CompletableFuture.completedFuture(this.getLoadedWithPermission(permission).entrySet().stream().collect(Collectors.toMap(e -> ((Subject)e.getKey()).asSubjectReference(), Map.Entry::getValue)));
    }

    @NotNull
    public CompletableFuture<Map<SubjectReference, Boolean>> getAllWithPermission(@NotNull Set<Context> contexts, @NotNull String permission) {
        return CompletableFuture.completedFuture(this.getLoadedWithPermission(contexts, permission).entrySet().stream().collect(Collectors.toMap(e -> ((Subject)e.getKey()).asSubjectReference(), Map.Entry::getValue)));
    }

    @NotNull
    public CompletableFuture<Set<String>> getAllIdentifiers() {
        return CompletableFuture.completedFuture(this.getLoadedSubjects().stream().map(Contextual::getIdentifier).collect(Collectors.toSet()));
    }

    @NotNull
    public Subject getDefaults() {
        return this.service.getDefaults();
    }

    public final void suggestUnload(@NotNull String identifier) {
    }
}

