/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.permissions.sponge.subject.base.user;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.SubjectData;
import systems.reformcloud.reformcloud2.permissions.PermissionManagement;
import systems.reformcloud.reformcloud2.permissions.nodes.NodeGroup;
import systems.reformcloud.reformcloud2.permissions.nodes.PermissionNode;
import systems.reformcloud.reformcloud2.permissions.objects.group.PermissionGroup;
import systems.reformcloud.reformcloud2.permissions.objects.user.PermissionUser;
import systems.reformcloud.reformcloud2.permissions.sponge.subject.AbstractSpongeSubjectData;
import systems.reformcloud.reformcloud2.permissions.sponge.subject.util.SubjectGroupPermissionCalculator;

public class SpongeSubjectData
extends AbstractSpongeSubjectData {
    private final UUID uniqueID;

    public SpongeSubjectData(@NotNull UUID user) {
        this.uniqueID = user;
    }

    @NotNull
    public Map<Set<Context>, Map<String, Boolean>> getAllPermissions() {
        return Collections.singletonMap(SubjectData.GLOBAL_CONTEXT, this.getPermissions());
    }

    @NotNull
    public Map<String, Boolean> getPermissions(@Nullable Set<Context> contexts) {
        return this.getPermissions();
    }

    private Map<String, Boolean> getPermissions() {
        HashMap<String, Boolean> out = new HashMap<String, Boolean>();
        PermissionUser user = PermissionManagement.getInstance().loadUser(this.uniqueID);
        for (PermissionNode permissionNode : user.getPermissionNodes()) {
            if (!permissionNode.isValid()) continue;
            out.putIfAbsent(permissionNode.getActualPermission(), permissionNode.isSet());
        }
        for (NodeGroup group : user.getGroups()) {
            if (!group.isValid()) continue;
            PermissionManagement.getInstance().getPermissionGroup(group.getGroupName()).ifPresent(permissionGroup -> {
                out.putAll(this.getPermissionsOf((PermissionGroup)permissionGroup));
                for (String sub : permissionGroup.getSubGroups()) {
                    PermissionManagement.getInstance().getPermissionGroup(sub).ifPresent(subGroup -> out.putAll(this.getPermissionsOf((PermissionGroup)subGroup)));
                }
            });
        }
        return out;
    }

    private Map<String, Boolean> getPermissionsOf(PermissionGroup group) {
        return SubjectGroupPermissionCalculator.getPermissionsOf(group);
    }
}

