/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.permissions.sponge.description;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.service.permission.PermissionDescription;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectReference;
import org.spongepowered.api.text.Text;

public class SpongePermissionDescription
implements PermissionDescription {
    private final PermissionService service;
    private final String id;
    private final PluginContainer owner;
    private final Text description;

    SpongePermissionDescription(@NotNull PermissionService service, @NotNull String id, @Nullable PluginContainer owner, @Nullable Text description) {
        this.service = service;
        this.id = id;
        this.owner = owner;
        this.description = description;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public Optional<Text> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @NotNull
    public Optional<PluginContainer> getOwner() {
        return Optional.ofNullable(this.owner);
    }

    @NotNull
    public CompletableFuture<Map<SubjectReference, Boolean>> findAssignedSubjects(@NotNull String collectionIdentifier) {
        return this.service.loadCollection(collectionIdentifier).thenCompose(e -> {
            if (e == null) {
                return CompletableFuture.completedFuture(new HashMap());
            }
            return e.getAllWithPermission(this.getId());
        });
    }

    @NotNull
    public Map<Subject, Boolean> getAssignedSubjects(@NotNull String collectionIdentifier) {
        return this.service.getCollection(collectionIdentifier).map(e -> e.getLoadedWithPermission(this.getId())).orElseGet(HashMap::new);
    }
}

