/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.permissions.packets;

import org.jetbrains.annotations.NotNull;
import systems.reformcloud.reformcloud2.executor.api.ExecutorAPI;
import systems.reformcloud.reformcloud2.executor.api.ExecutorType;
import systems.reformcloud.reformcloud2.executor.api.network.SerializableObject;
import systems.reformcloud.reformcloud2.executor.api.network.channel.EndpointChannelReader;
import systems.reformcloud.reformcloud2.executor.api.network.channel.NetworkChannel;
import systems.reformcloud.reformcloud2.executor.api.network.channel.manager.ChannelManager;
import systems.reformcloud.reformcloud2.executor.api.network.data.ProtocolBuffer;
import systems.reformcloud.reformcloud2.executor.api.network.packet.Packet;
import systems.reformcloud.reformcloud2.permissions.PermissionManagement;
import systems.reformcloud.reformcloud2.permissions.objects.user.PermissionUser;
import systems.reformcloud.reformcloud2.permissions.packets.util.PermissionAction;

public class PacketUserAction
extends Packet {
    private PermissionUser permissionUser;
    private PermissionAction permissionAction;

    public PacketUserAction() {
    }

    public PacketUserAction(PermissionUser permissionUser, PermissionAction permissionAction) {
        this.permissionUser = permissionUser;
        this.permissionAction = permissionAction;
    }

    public int getId() {
        return 8004;
    }

    public void handlePacketReceive(@NotNull EndpointChannelReader reader, @NotNull NetworkChannel channel) {
        switch (this.permissionAction) {
            case DELETE: {
                PermissionManagement.getInstance().handleInternalUserDelete(this.permissionUser);
                if (ExecutorAPI.getInstance().getType() == ExecutorType.API) break;
                this.publish(new PacketUserAction(this.permissionUser, PermissionAction.DELETE));
                break;
            }
            case UPDATE: {
                PermissionManagement.getInstance().handleInternalUserUpdate(this.permissionUser);
                if (ExecutorAPI.getInstance().getType() == ExecutorType.API) break;
                this.publish(new PacketUserAction(this.permissionUser, PermissionAction.UPDATE));
                break;
            }
            case CREATE: {
                PermissionManagement.getInstance().handleInternalUserCreate(this.permissionUser);
                if (ExecutorAPI.getInstance().getType() == ExecutorType.API) break;
                this.publish(new PacketUserAction(this.permissionUser, PermissionAction.CREATE));
            }
        }
    }

    public void write(@NotNull ProtocolBuffer buffer) {
        buffer.writeObject((SerializableObject)this.permissionUser);
        buffer.writeInt(this.permissionAction.ordinal());
    }

    public void read(@NotNull ProtocolBuffer buffer) {
        this.permissionUser = (PermissionUser)buffer.readObject(PermissionUser.class);
        this.permissionAction = PermissionAction.values()[buffer.readInt()];
    }

    private void publish(@NotNull Packet packet) {
        for (NetworkChannel registeredChannel : ((ChannelManager)ExecutorAPI.getInstance().getServiceRegistry().getProviderUnchecked(ChannelManager.class)).getRegisteredChannels()) {
            if (!registeredChannel.isAuthenticated() || ExecutorAPI.getInstance().getNodeInformationProvider().getNodeInformation(registeredChannel.getName()).isPresent()) continue;
            registeredChannel.sendPacket((Object)packet);
        }
    }
}

