/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.permissions.packets;

import org.jetbrains.annotations.NotNull;
import systems.reformcloud.reformcloud2.executor.api.ExecutorAPI;
import systems.reformcloud.reformcloud2.executor.api.ExecutorType;
import systems.reformcloud.reformcloud2.executor.api.network.SerializableObject;
import systems.reformcloud.reformcloud2.executor.api.network.channel.EndpointChannelReader;
import systems.reformcloud.reformcloud2.executor.api.network.channel.NetworkChannel;
import systems.reformcloud.reformcloud2.executor.api.network.data.ProtocolBuffer;
import systems.reformcloud.reformcloud2.executor.api.network.packet.Packet;
import systems.reformcloud.reformcloud2.permissions.PermissionManagement;
import systems.reformcloud.reformcloud2.permissions.objects.group.PermissionGroup;
import systems.reformcloud.reformcloud2.permissions.packets.util.PermissionAction;

public class PacketGroupAction
extends Packet {
    private PermissionGroup permissionGroup;
    private PermissionAction permissionAction;

    public PacketGroupAction() {
    }

    public PacketGroupAction(PermissionGroup permissionGroup, PermissionAction permissionAction) {
        this.permissionGroup = permissionGroup;
        this.permissionAction = permissionAction;
    }

    public int getId() {
        return 8001;
    }

    public void handlePacketReceive(@NotNull EndpointChannelReader reader, @NotNull NetworkChannel channel) {
        if (ExecutorAPI.getInstance().getType() != ExecutorType.API) {
            switch (this.permissionAction) {
                case CREATE: {
                    PermissionManagement.getInstance().createPermissionGroup(this.permissionGroup);
                    PermissionManagement.getInstance().handleInternalPermissionGroupCreate(this.permissionGroup);
                    break;
                }
                case UPDATE: {
                    PermissionManagement.getInstance().updateGroup(this.permissionGroup);
                    PermissionManagement.getInstance().handleInternalPermissionGroupUpdate(this.permissionGroup);
                    break;
                }
                case DELETE: {
                    PermissionManagement.getInstance().deleteGroup(this.permissionGroup.getName());
                    PermissionManagement.getInstance().handleInternalPermissionGroupDelete(this.permissionGroup);
                }
            }
            return;
        }
        switch (this.permissionAction) {
            case UPDATE: {
                PermissionManagement.getInstance().handleInternalPermissionGroupUpdate(this.permissionGroup);
                break;
            }
            case DELETE: {
                PermissionManagement.getInstance().handleInternalPermissionGroupDelete(this.permissionGroup);
                break;
            }
            case CREATE: {
                PermissionManagement.getInstance().handleInternalPermissionGroupCreate(this.permissionGroup);
            }
        }
    }

    public void write(@NotNull ProtocolBuffer buffer) {
        buffer.writeObject((SerializableObject)this.permissionGroup);
        buffer.writeInt(this.permissionAction.ordinal());
    }

    public void read(@NotNull ProtocolBuffer buffer) {
        this.permissionGroup = (PermissionGroup)buffer.readObject(PermissionGroup.class);
        this.permissionAction = PermissionAction.values()[buffer.readInt()];
    }
}

