/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.permissions.objects.user;

import com.google.gson.reflect.TypeToken;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import systems.reformcloud.reformcloud2.executor.api.configuration.gson.JsonConfiguration;
import systems.reformcloud.reformcloud2.executor.api.network.SerializableObject;
import systems.reformcloud.reformcloud2.executor.api.network.data.ProtocolBuffer;
import systems.reformcloud.reformcloud2.permissions.PermissionManagement;
import systems.reformcloud.reformcloud2.permissions.checks.GeneralCheck;
import systems.reformcloud.reformcloud2.permissions.checks.WildcardCheck;
import systems.reformcloud.reformcloud2.permissions.nodes.NodeGroup;
import systems.reformcloud.reformcloud2.permissions.nodes.PermissionNode;
import systems.reformcloud.reformcloud2.permissions.objects.group.PermissionGroup;

public class PermissionUser
implements SerializableObject {
    public static final TypeToken<PermissionUser> TYPE = new TypeToken<PermissionUser>(){};
    private UUID uuid;
    private Collection<PermissionNode> permissionNodes;
    private Collection<NodeGroup> groups;
    private Map<String, Collection<PermissionNode>> perGroupPermissions;
    @Nullable
    private String prefix;
    @Nullable
    private String suffix;
    @Nullable
    private String display;
    @Nullable
    private String colour;
    private JsonConfiguration extra;

    @ApiStatus.Internal
    public PermissionUser() {
    }

    public PermissionUser(@NotNull UUID uuid, @NotNull Collection<PermissionNode> permissionNodes, @NotNull Collection<NodeGroup> groups) {
        this.uuid = uuid;
        this.permissionNodes = permissionNodes;
        this.groups = groups;
        this.perGroupPermissions = new ConcurrentHashMap<String, Collection<PermissionNode>>();
        this.extra = new JsonConfiguration();
    }

    @NotNull
    public UUID getUniqueID() {
        return this.uuid;
    }

    @NotNull
    public Collection<PermissionNode> getPermissionNodes() {
        return this.permissionNodes;
    }

    @NotNull
    public Collection<NodeGroup> getGroups() {
        return this.groups;
    }

    @NotNull
    public Map<String, Collection<PermissionNode>> getPerGroupPermissions() {
        return this.perGroupPermissions == null ? (this.perGroupPermissions = new HashMap<String, Collection<PermissionNode>>()) : this.perGroupPermissions;
    }

    @NotNull
    public Optional<String> getPrefix() {
        if (this.prefix == null) {
            return this.getHighestPermissionGroup().flatMap(PermissionGroup::getPrefix);
        }
        return Optional.of(this.prefix);
    }

    public void setPrefix(@Nullable String prefix) {
        this.prefix = prefix;
    }

    @NotNull
    public Optional<String> getSuffix() {
        if (this.suffix == null) {
            return this.getHighestPermissionGroup().flatMap(PermissionGroup::getSuffix);
        }
        return Optional.of(this.suffix);
    }

    public void setSuffix(@Nullable String suffix) {
        this.suffix = suffix;
    }

    @NotNull
    public Optional<String> getDisplay() {
        if (this.display == null) {
            return this.getHighestPermissionGroup().flatMap(PermissionGroup::getDisplay);
        }
        return Optional.of(this.display);
    }

    public void setDisplay(@Nullable String display) {
        this.display = display;
    }

    @NotNull
    public Optional<String> getColour() {
        if (this.colour == null) {
            return this.getHighestPermissionGroup().flatMap(PermissionGroup::getColour);
        }
        return Optional.of(this.colour);
    }

    public void setColour(@Nullable String colour) {
        this.colour = colour;
    }

    @NotNull
    public JsonConfiguration getExtra() {
        return this.extra == null ? new JsonConfiguration() : this.extra;
    }

    @NotNull
    public Optional<PermissionGroup> getHighestPermissionGroup() {
        PermissionGroup permissionGroup = null;
        for (NodeGroup nodeGroup : this.groups) {
            PermissionGroup group = PermissionManagement.getInstance().getPermissionGroup(nodeGroup.getGroupName()).orElse(null);
            if (group == null) continue;
            if (permissionGroup == null) {
                permissionGroup = group;
                continue;
            }
            if (permissionGroup.getPriority() <= group.getPriority()) continue;
            permissionGroup = group;
        }
        return Optional.ofNullable(permissionGroup);
    }

    public boolean isInGroup(@NotNull String group) {
        for (NodeGroup nodeGroup : this.groups) {
            if (!nodeGroup.getGroupName().equals(group) || !nodeGroup.isValid()) continue;
            return true;
        }
        return false;
    }

    public boolean hasPermission(String permission) {
        if (permission == null) {
            return false;
        }
        if ((permission = permission.toLowerCase()).equalsIgnoreCase("bukkit.brodcast") || permission.equalsIgnoreCase("bukkit.brodcast.admin")) {
            return true;
        }
        Boolean general = GeneralCheck.hasPermission(this, permission);
        if (general != null) {
            return general;
        }
        Boolean wildCard = WildcardCheck.hasWildcardPermission(this, permission);
        if (wildCard != null) {
            return wildCard;
        }
        return PermissionManagement.getInstance().hasPermission(this, permission);
    }

    public void write(@NotNull ProtocolBuffer buffer) {
        buffer.writeUniqueId(this.uuid);
        buffer.writeObjects(this.groups);
        buffer.writeObjects(this.permissionNodes);
        buffer.writeVarInt(this.getPerGroupPermissions().size());
        for (Map.Entry<String, Collection<PermissionNode>> stringCollectionEntry : this.getPerGroupPermissions().entrySet()) {
            buffer.writeString(stringCollectionEntry.getKey());
            buffer.writeObjects(stringCollectionEntry.getValue());
        }
        buffer.writeString(this.prefix);
        buffer.writeString(this.suffix);
        buffer.writeString(this.display);
        buffer.writeString(this.colour);
        buffer.writeArray(this.getExtra().toPrettyBytes());
    }

    public void read(@NotNull ProtocolBuffer buffer) {
        this.uuid = buffer.readUniqueId();
        this.groups = buffer.readObjects(NodeGroup.class);
        this.permissionNodes = buffer.readObjects(PermissionNode.class);
        int size = buffer.readVarInt();
        this.perGroupPermissions = new HashMap<String, Collection<PermissionNode>>(size);
        for (int i = 0; i < size; ++i) {
            this.perGroupPermissions.put(buffer.readString(), buffer.readObjects(PermissionNode.class));
        }
        this.prefix = buffer.readString();
        this.suffix = buffer.readString();
        this.display = buffer.readString();
        this.colour = buffer.readString();
        this.extra = new JsonConfiguration(buffer.readArray());
    }
}

