/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.permissions.nodes;

import org.jetbrains.annotations.NotNull;
import systems.reformcloud.reformcloud2.executor.api.network.SerializableObject;
import systems.reformcloud.reformcloud2.executor.api.network.data.ProtocolBuffer;

public class PermissionNode
implements SerializableObject {
    private long addTime;
    private long timeout;
    private boolean set;
    private String actualPermission;

    public PermissionNode() {
    }

    public PermissionNode(long addTime, long timeout, boolean set, @NotNull String actualPermission) {
        this.addTime = addTime;
        this.timeout = timeout;
        this.set = set;
        this.actualPermission = actualPermission;
    }

    @NotNull
    public static PermissionNode createNode(@NotNull String permission, long timeout, boolean positive) {
        return new PermissionNode(System.currentTimeMillis(), timeout, positive, permission);
    }

    public long getAddTime() {
        return this.addTime;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public boolean isSet() {
        return this.set && (this.timeout == -1L || this.timeout > System.currentTimeMillis());
    }

    public boolean isValid() {
        return this.timeout == -1L || this.timeout > System.currentTimeMillis();
    }

    @NotNull
    public String getActualPermission() {
        return this.actualPermission;
    }

    public void write(@NotNull ProtocolBuffer buffer) {
        buffer.writeLong(this.addTime);
        buffer.writeLong(this.timeout);
        buffer.writeBoolean(this.set);
        buffer.writeString(this.actualPermission);
    }

    public void read(@NotNull ProtocolBuffer buffer) {
        this.addTime = buffer.readLong();
        this.timeout = buffer.readLong();
        this.set = buffer.readBoolean();
        this.actualPermission = buffer.readString();
    }
}

