/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.permissions.bukkit.vault;

import java.util.Optional;
import java.util.UUID;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.jetbrains.annotations.NotNull;
import systems.reformcloud.reformcloud2.permissions.PermissionManagement;
import systems.reformcloud.reformcloud2.permissions.bukkit.vault.PermissionVaultChatImplementation;
import systems.reformcloud.reformcloud2.permissions.bukkit.vault.PermissionVaultPermissionImplementation;
import systems.reformcloud.reformcloud2.permissions.internal.UUIDFetcher;
import systems.reformcloud.reformcloud2.permissions.objects.user.PermissionUser;

public final class VaultUtil {
    private VaultUtil() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static Optional<PermissionUser> getUserFromName(@NotNull String name) {
        Player player = Bukkit.getPlayer((String)name);
        if (player != null) {
            return PermissionManagement.getInstance().getExistingUser(player.getUniqueId());
        }
        UUID uniqueID = UUIDFetcher.getUUIDFromName(name);
        if (uniqueID != null) {
            return PermissionManagement.getInstance().getExistingUser(uniqueID);
        }
        return Optional.empty();
    }

    public static void tryInvoke(@NotNull Plugin plugin) {
        PermissionVaultPermissionImplementation permission = new PermissionVaultPermissionImplementation();
        Bukkit.getServicesManager().register(Permission.class, (Object)permission, plugin, ServicePriority.Highest);
        Bukkit.getServicesManager().register(Chat.class, (Object)new PermissionVaultChatImplementation(permission), plugin, ServicePriority.Highest);
        plugin.getLogger().info("Successfully hooked into vault");
    }
}

