/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.permissions.bukkit.vault;

import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.permission.Permission;
import systems.reformcloud.reformcloud2.permissions.PermissionManagement;
import systems.reformcloud.reformcloud2.permissions.bukkit.vault.VaultUtil;
import systems.reformcloud.reformcloud2.permissions.objects.group.PermissionGroup;
import systems.reformcloud.reformcloud2.permissions.objects.user.PermissionUser;

public class PermissionVaultChatImplementation
extends Chat {
    private final PermissionManagement permissionManagement = PermissionManagement.getInstance();

    PermissionVaultChatImplementation(Permission perms) {
        super(perms);
    }

    public String getName() {
        return "ReformCloud2BukkitPermissions";
    }

    public boolean isEnabled() {
        return true;
    }

    public String getPlayerPrefix(String world, String player) {
        return VaultUtil.getUserFromName(player).flatMap(PermissionUser::getPrefix).orElse(null);
    }

    public void setPlayerPrefix(String world, String player, String prefix) {
        VaultUtil.getUserFromName(player).ifPresent(user -> {
            user.setPrefix(prefix);
            this.permissionManagement.updateUser((PermissionUser)user);
        });
    }

    public String getPlayerSuffix(String world, String player) {
        return VaultUtil.getUserFromName(player).flatMap(PermissionUser::getSuffix).orElse(null);
    }

    public void setPlayerSuffix(String world, String player, String suffix) {
        VaultUtil.getUserFromName(player).ifPresent(user -> {
            user.setSuffix(suffix);
            this.permissionManagement.updateUser((PermissionUser)user);
        });
    }

    public String getGroupPrefix(String world, String group) {
        return this.permissionManagement.getPermissionGroup(group).flatMap(PermissionGroup::getPrefix).orElse(null);
    }

    public void setGroupPrefix(String world, String group, String prefix) {
        this.permissionManagement.getPermissionGroup(group).ifPresent(permissionGroup -> {
            permissionGroup.setPrefix(prefix);
            this.permissionManagement.updateGroup((PermissionGroup)permissionGroup);
        });
    }

    public String getGroupSuffix(String world, String group) {
        return this.permissionManagement.getPermissionGroup(group).flatMap(PermissionGroup::getSuffix).orElse(null);
    }

    public void setGroupSuffix(String world, String group, String suffix) {
        this.permissionManagement.getPermissionGroup(group).ifPresent(permissionGroup -> {
            permissionGroup.setSuffix(suffix);
            this.permissionManagement.updateGroup((PermissionGroup)permissionGroup);
        });
    }

    public int getPlayerInfoInteger(String world, String player, String node, int defaultValue) {
        return VaultUtil.getUserFromName(player).map(user -> user.getExtra().getOrDefault(node, Integer.valueOf(defaultValue))).orElse(defaultValue);
    }

    public void setPlayerInfoInteger(String world, String player, String node, int value) {
        VaultUtil.getUserFromName(player).ifPresent(permissionUser -> {
            permissionUser.getExtra().add(node, Integer.valueOf(value));
            this.permissionManagement.updateUser((PermissionUser)permissionUser);
        });
    }

    public int getGroupInfoInteger(String world, String group, String node, int defaultValue) {
        return this.permissionManagement.getPermissionGroup(group).map(g -> g.getExtra().getOrDefault(node, Integer.valueOf(defaultValue))).orElse(defaultValue);
    }

    public void setGroupInfoInteger(String world, String group, String node, int value) {
        this.permissionManagement.getPermissionGroup(group).ifPresent(permissionGroup -> {
            permissionGroup.getExtra().add(node, Integer.valueOf(value));
            this.permissionManagement.updateGroup((PermissionGroup)permissionGroup);
        });
    }

    public double getPlayerInfoDouble(String world, String player, String node, double defaultValue) {
        return VaultUtil.getUserFromName(player).map(user -> user.getExtra().getOrDefault(node, Double.valueOf(defaultValue))).orElse(defaultValue);
    }

    public void setPlayerInfoDouble(String world, String player, String node, double value) {
        VaultUtil.getUserFromName(player).ifPresent(permissionUser -> {
            permissionUser.getExtra().add(node, Double.valueOf(value));
            this.permissionManagement.updateUser((PermissionUser)permissionUser);
        });
    }

    public double getGroupInfoDouble(String world, String group, String node, double defaultValue) {
        return this.permissionManagement.getPermissionGroup(group).map(g -> g.getExtra().getOrDefault(node, Double.valueOf(defaultValue))).orElse(defaultValue);
    }

    public void setGroupInfoDouble(String world, String group, String node, double value) {
        this.permissionManagement.getPermissionGroup(group).ifPresent(permissionGroup -> {
            permissionGroup.getExtra().add(node, Double.valueOf(value));
            this.permissionManagement.updateGroup((PermissionGroup)permissionGroup);
        });
    }

    public boolean getPlayerInfoBoolean(String world, String player, String node, boolean defaultValue) {
        return VaultUtil.getUserFromName(player).map(user -> user.getExtra().getOrDefault(node, Boolean.valueOf(defaultValue))).orElse(defaultValue);
    }

    public void setPlayerInfoBoolean(String world, String player, String node, boolean value) {
        VaultUtil.getUserFromName(player).ifPresent(permissionUser -> {
            permissionUser.getExtra().add(node, Boolean.valueOf(value));
            this.permissionManagement.updateUser((PermissionUser)permissionUser);
        });
    }

    public boolean getGroupInfoBoolean(String world, String group, String node, boolean defaultValue) {
        return this.permissionManagement.getPermissionGroup(group).map(g -> g.getExtra().getOrDefault(node, Boolean.valueOf(defaultValue))).orElse(defaultValue);
    }

    public void setGroupInfoBoolean(String world, String group, String node, boolean value) {
        this.permissionManagement.getPermissionGroup(group).ifPresent(permissionGroup -> {
            permissionGroup.getExtra().add(node, Boolean.valueOf(value));
            this.permissionManagement.updateGroup((PermissionGroup)permissionGroup);
        });
    }

    public String getPlayerInfoString(String world, String player, String node, String defaultValue) {
        return VaultUtil.getUserFromName(player).map(user -> user.getExtra().getOrDefault(node, defaultValue)).orElse(defaultValue);
    }

    public void setPlayerInfoString(String world, String player, String node, String value) {
        VaultUtil.getUserFromName(player).ifPresent(permissionUser -> {
            permissionUser.getExtra().add(node, value);
            this.permissionManagement.updateUser((PermissionUser)permissionUser);
        });
    }

    public String getGroupInfoString(String world, String group, String node, String defaultValue) {
        return this.permissionManagement.getPermissionGroup(group).map(g -> g.getExtra().getOrDefault(node, defaultValue)).orElse(defaultValue);
    }

    public void setGroupInfoString(String world, String group, String node, String value) {
        this.permissionManagement.getPermissionGroup(group).ifPresent(permissionGroup -> {
            permissionGroup.getExtra().add(node, value);
            this.permissionManagement.updateGroup((PermissionGroup)permissionGroup);
        });
    }
}

