/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.permissions;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;
import systems.reformcloud.reformcloud2.executor.api.ExecutorAPI;
import systems.reformcloud.reformcloud2.executor.api.base.Conditions;
import systems.reformcloud.reformcloud2.executor.api.event.Event;
import systems.reformcloud.reformcloud2.executor.api.event.EventManager;
import systems.reformcloud.reformcloud2.permissions.defaults.DefaultPermissionManagement;
import systems.reformcloud.reformcloud2.permissions.events.system.PermissionManagerSetupEvent;
import systems.reformcloud.reformcloud2.permissions.nodes.NodeGroup;
import systems.reformcloud.reformcloud2.permissions.nodes.PermissionNode;
import systems.reformcloud.reformcloud2.permissions.objects.group.PermissionGroup;
import systems.reformcloud.reformcloud2.permissions.objects.user.PermissionUser;

public abstract class PermissionManagement {
    private static PermissionManagement instance;

    @ApiStatus.Internal
    public static void setup() {
        Conditions.isTrue((instance == null ? 1 : 0) != 0, (Object)"Cannot redefine singleton permission management instance");
        PermissionManagerSetupEvent permissionManagerSetupEvent = new PermissionManagerSetupEvent(new DefaultPermissionManagement());
        ((EventManager)ExecutorAPI.getInstance().getServiceRegistry().getProviderUnchecked(EventManager.class)).callEvent((Event)permissionManagerSetupEvent);
        instance = permissionManagerSetupEvent.getPermissionManagement();
    }

    @NotNull
    public static PermissionManagement getInstance() {
        return Objects.requireNonNull(instance, "Permission management instance is not set yet");
    }

    @Deprecated
    @Nullable
    @ApiStatus.ScheduledForRemoval
    public PermissionGroup getGroup(@NotNull String name) {
        return this.getPermissionGroup(name).orElse(null);
    }

    @NotNull
    public abstract Optional<PermissionGroup> getPermissionGroup(@NotNull String var1);

    public abstract void updateGroup(@NotNull PermissionGroup var1);

    public abstract void addGroupPermission(@NotNull PermissionGroup var1, @NotNull PermissionNode var2);

    public abstract void addProcessGroupPermission(@NotNull String var1, @NotNull PermissionGroup var2, @NotNull PermissionNode var3);

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval
    public abstract PermissionGroup createGroup(@NotNull String var1);

    @NotNull
    public abstract PermissionGroup createPermissionGroup(@NotNull PermissionGroup var1);

    @NotNull
    public abstract Collection<PermissionGroup> getDefaultGroups();

    @NotNull
    public abstract @UnmodifiableView Collection<PermissionGroup> getPermissionGroups();

    public abstract void deleteGroup(@NotNull String var1);

    public abstract boolean hasPermission(@NotNull PermissionUser var1, @NotNull String var2);

    public abstract boolean hasPermission(@NotNull PermissionGroup var1, @NotNull String var2);

    @NotNull
    public abstract PermissionUser loadUser(@NotNull UUID var1);

    @NotNull
    public abstract Optional<PermissionUser> getFirstExistingUser(@NotNull String var1);

    @NotNull
    public abstract Optional<PermissionUser> loadUser(@NotNull String var1);

    @NotNull
    public abstract Optional<PermissionUser> getExistingUser(@NotNull UUID var1);

    @NotNull
    public abstract PermissionUser loadUser(@NotNull UUID var1, @Nullable String var2);

    public abstract void assignDefaultGroups(@NotNull UUID var1);

    public abstract void assignDefaultGroups(@NotNull PermissionUser var1);

    public abstract void addUserPermission(@NotNull UUID var1, @NotNull PermissionNode var2);

    public abstract void removeUserGroup(@NotNull UUID var1, @NotNull String var2);

    public abstract void addUserGroup(@NotNull UUID var1, @NotNull NodeGroup var2);

    public abstract void updateUser(@NotNull PermissionUser var1);

    public abstract void deleteUser(@NotNull UUID var1);

    @ApiStatus.Internal
    public abstract void handleDisconnect(UUID var1);

    @ApiStatus.Internal
    public abstract void handleInternalPermissionGroupUpdate(PermissionGroup var1);

    @ApiStatus.Internal
    public abstract void handleInternalPermissionGroupCreate(PermissionGroup var1);

    @ApiStatus.Internal
    public abstract void handleInternalPermissionGroupDelete(PermissionGroup var1);

    @ApiStatus.Internal
    public abstract void handleInternalUserUpdate(PermissionUser var1);

    @ApiStatus.Internal
    public abstract void handleInternalUserCreate(PermissionUser var1);

    @ApiStatus.Internal
    public abstract void handleInternalUserDelete(PermissionUser var1);
}

