/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.permissions.bukkit.permissible;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.plugin.Plugin;
import systems.reformcloud.reformcloud2.executor.api.api.API;
import systems.reformcloud.reformcloud2.executor.api.common.process.ProcessInformation;
import systems.reformcloud.reformcloud2.permissions.PermissionAPI;
import systems.reformcloud.reformcloud2.permissions.util.group.NodeGroup;
import systems.reformcloud.reformcloud2.permissions.util.group.PermissionGroup;
import systems.reformcloud.reformcloud2.permissions.util.permission.PermissionNode;
import systems.reformcloud.reformcloud2.permissions.util.user.PermissionUser;

public class DefaultPermissible
extends PermissibleBase {
    private final UUID uuid;
    private Set<PermissionAttachmentInfo> perms;

    public DefaultPermissible(Player player) {
        super((ServerOperator)player);
        this.uuid = player.getUniqueId();
    }

    public boolean isOp() {
        return false;
    }

    public void setOp(boolean value) {
    }

    public boolean isPermissionSet(@Nonnull String name) {
        return this.has(name);
    }

    public boolean isPermissionSet(@Nonnull Permission perm) {
        return this.has(perm.getName());
    }

    public boolean hasPermission(@Nonnull String name) {
        return this.has(name);
    }

    public boolean hasPermission(@Nonnull Permission perm) {
        return this.has(perm.getName());
    }

    @Nonnull
    public PermissionAttachment addAttachment(@Nonnull Plugin plugin, @Nonnull String name, boolean value) {
        return new PermissionAttachment(plugin, (Permissible)this);
    }

    @Nonnull
    public PermissionAttachment addAttachment(@Nonnull Plugin plugin) {
        return new PermissionAttachment(plugin, (Permissible)this);
    }

    public void removeAttachment(@Nonnull PermissionAttachment attachment) {
    }

    public void recalculatePermissions() {
    }

    public synchronized void clearPermissions() {
    }

    public PermissionAttachment addAttachment(@Nonnull Plugin plugin, @Nonnull String name, boolean value, int ticks) {
        return new PermissionAttachment(plugin, (Permissible)this);
    }

    public PermissionAttachment addAttachment(@Nonnull Plugin plugin, int ticks) {
        return new PermissionAttachment(plugin, (Permissible)this);
    }

    @Nonnull
    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        this.perms = new HashSet<PermissionAttachmentInfo>();
        PermissionUser permissionUser = PermissionAPI.getInstance().getPermissionUtil().loadUser(this.uuid);
        ProcessInformation current = API.getInstance().getCurrentProcessInformation();
        permissionUser.getPermissionNodes().stream().filter(PermissionNode::isValid).forEach(e -> this.perms.add(new PermissionAttachmentInfo((Permissible)this, e.getActualPermission(), null, e.isSet())));
        permissionUser.getGroups().stream().filter(NodeGroup::isValid).map(e -> PermissionAPI.getInstance().getPermissionUtil().getGroup(e.getGroupName())).filter(Objects::nonNull).flatMap(e -> {
            Stream.Builder<PermissionGroup> stream = Stream.builder().add((PermissionGroup)e);
            e.getSubGroups().stream().map(g -> PermissionAPI.getInstance().getPermissionUtil().getGroup((String)g)).filter(Objects::nonNull).forEach(stream);
            return stream.build();
        }).forEach(g -> {
            g.getPermissionNodes().stream().filter(PermissionNode::isValid).forEach(e -> this.perms.add(new PermissionAttachmentInfo((Permissible)this, e.getActualPermission(), null, e.isSet())));
            Collection<PermissionNode> nodes = g.getPerGroupPermissions().get(current.getProcessGroup().getName());
            if (nodes != null) {
                nodes.stream().filter(PermissionNode::isValid).forEach(e -> this.perms.add(new PermissionAttachmentInfo((Permissible)this, e.getActualPermission(), null, e.isSet())));
            }
        });
        return this.perms;
    }

    private boolean has(String name) {
        PermissionUser permissionUser = PermissionAPI.getInstance().getPermissionUtil().loadUser(this.uuid);
        return permissionUser.hasPermission(name);
    }
}

