/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.permissions.sponge.subject.base.user;

import java.util.UUID;
import javax.annotation.Nonnull;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.SubjectCollection;
import systems.reformcloud.reformcloud2.permissions.PermissionAPI;
import systems.reformcloud.reformcloud2.permissions.sponge.subject.impl.AbstractUserSpongeSubject;

public class SpongeSubject
extends AbstractUserSpongeSubject {
    private final UUID uniqueUserID;
    private final SubjectCollection source;
    private final PermissionService service;

    public SpongeSubject(@Nonnull UUID user, @Nonnull SubjectCollection source, @Nonnull PermissionService service) {
        super(user);
        this.uniqueUserID = user;
        this.source = source;
        this.service = service;
    }

    @Override
    protected PermissionService service() {
        return this.service;
    }

    @Override
    protected boolean has(String permission) {
        return PermissionAPI.getInstance().getPermissionUtil().loadUser(this.uniqueUserID).hasPermission(permission);
    }

    @Nonnull
    public SubjectCollection getContainingCollection() {
        return this.source;
    }

    @Nonnull
    public String getIdentifier() {
        return this.uniqueUserID.toString();
    }
}

