/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.permissions.util.uuid;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import systems.reformcloud.reformcloud2.executor.api.common.ExecutorAPI;
import systems.reformcloud.reformcloud2.executor.api.common.configuration.JsonConfiguration;

public class UUIDFetcher {
    private static final Pattern PATTERN = Pattern.compile("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})");
    private static final Map<String, UUID> CACHE = new ConcurrentHashMap<String, UUID>();

    private UUIDFetcher() {
        throw new UnsupportedOperationException();
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static UUID getUUIDFromName(String name) {
        block23: {
            if (CACHE.containsKey(name)) {
                return CACHE.get(name);
            }
            UUID database = UUIDFetcher.fromDatabase(name);
            if (database != null) {
                return database;
            }
            try {
                HttpURLConnection httpURLConnection = (HttpURLConnection)new URL("https://api.minetools.eu/uuid/" + name).openConnection();
                httpURLConnection.setDoOutput(false);
                httpURLConnection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
                httpURLConnection.setUseCaches(true);
                httpURLConnection.connect();
                Throwable throwable = null;
                try (InputStreamReader reader = new InputStreamReader(httpURLConnection.getInputStream());){
                    JsonConfiguration configuration = new JsonConfiguration((Reader)reader);
                    if (!configuration.has("id")) break block23;
                    try {
                        UUID uuid = UUIDFetcher.fromString(PATTERN.matcher(configuration.getString("id")).replaceAll("$1-$2-$3-$4-$5"));
                        CACHE.put(name, uuid);
                        UUID uUID = uuid;
                        return uUID;
                    }
                    catch (IllegalArgumentException ex) {
                        UUID uUID;
                        block24: {
                            block25: {
                                uUID = null;
                                if (reader == null) break block24;
                                if (throwable == null) break block25;
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block24;
                            }
                            reader.close();
                        }
                        return uUID;
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            throw throwable4;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static UUID fromDatabase(String name) {
        JsonConfiguration configuration = ExecutorAPI.getInstance().getSyncAPI().getDatabaseSyncAPI().find("reformcloud_internal_db_perm_name_uuid", name, null);
        return configuration == null || !configuration.has("id") ? null : (UUID)configuration.get("id", UUID.class);
    }

    private static UUID fromString(String name) throws IllegalArgumentException {
        String[] components = name.split("-");
        if (components.length != 5) {
            throw new IllegalArgumentException("Invalid UUID string: " + name);
        }
        for (int i = 0; i < 5; ++i) {
            components[i] = "0x" + components[i];
        }
        long mostSigBits = Long.decode(components[0]);
        mostSigBits <<= 16;
        mostSigBits |= Long.decode(components[1]).longValue();
        mostSigBits <<= 16;
        long leastSigBits = Long.decode(components[3]);
        leastSigBits <<= 48;
        return new UUID(mostSigBits |= Long.decode(components[2]).longValue(), leastSigBits |= Long.decode(components[4]).longValue());
    }
}

