/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.permissions.sponge.collections;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.context.Contextual;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectCollection;
import org.spongepowered.api.service.permission.SubjectReference;
import org.spongepowered.api.util.Tristate;

public abstract class DefaultSubjectCollection
implements SubjectCollection {
    private final String type;
    protected final PermissionService service;

    public DefaultSubjectCollection(String type, PermissionService service) {
        this.type = type;
        this.service = service;
    }

    @Nonnull
    protected abstract Subject load(String var1);

    @Nonnull
    public String getIdentifier() {
        return this.type;
    }

    @Nonnull
    public Predicate<String> getIdentifierValidityPredicate() {
        return s -> true;
    }

    @Nonnull
    public SubjectReference newSubjectReference(@Nonnull String subjectIdentifier) {
        return this.service.newSubjectReference(this.type, subjectIdentifier);
    }

    @Nonnull
    public CompletableFuture<Subject> loadSubject(@Nonnull String identifier) {
        return CompletableFuture.completedFuture(this.load(identifier));
    }

    @Nonnull
    public Optional<Subject> getSubject(@Nonnull String identifier) {
        return Optional.of(this.load(identifier));
    }

    @Nonnull
    public CompletableFuture<Map<String, Subject>> loadSubjects(@Nonnull Set<String> identifiers) {
        ConcurrentHashMap ref = new ConcurrentHashMap();
        identifiers.forEach(id -> ref.put(id, this.load((String)id)));
        return CompletableFuture.completedFuture(ref);
    }

    @Nonnull
    public Map<Subject, Boolean> getLoadedWithPermission(@Nonnull String permission) {
        return this.getLoadedWithPermission(null, permission);
    }

    @Nonnull
    public Map<Subject, Boolean> getLoadedWithPermission(@Nullable Set<Context> contexts, @Nonnull String permission) {
        ConcurrentHashMap<Subject, Boolean> out = new ConcurrentHashMap<Subject, Boolean>();
        this.getLoadedSubjects().forEach(e -> {
            Tristate tristate = e.getPermissionValue(contexts == null ? e.getActiveContexts() : contexts, permission);
            if (tristate.equals((Object)Tristate.UNDEFINED)) {
                return;
            }
            out.put((Subject)e, tristate.asBoolean());
        });
        return out;
    }

    @Nonnull
    public CompletableFuture<Map<SubjectReference, Boolean>> getAllWithPermission(@Nonnull String permission) {
        return CompletableFuture.completedFuture(this.getLoadedWithPermission(permission).entrySet().stream().collect(Collectors.toMap(e -> ((Subject)e.getKey()).asSubjectReference(), Map.Entry::getValue)));
    }

    @Nonnull
    public CompletableFuture<Map<SubjectReference, Boolean>> getAllWithPermission(@Nonnull Set<Context> contexts, @Nonnull String permission) {
        return CompletableFuture.completedFuture(this.getLoadedWithPermission(contexts, permission).entrySet().stream().collect(Collectors.toMap(e -> ((Subject)e.getKey()).asSubjectReference(), Map.Entry::getValue)));
    }

    @Nonnull
    public CompletableFuture<Set<String>> getAllIdentifiers() {
        return CompletableFuture.completedFuture(this.getLoadedSubjects().stream().map(Contextual::getIdentifier).collect(Collectors.toSet()));
    }

    @Nonnull
    public Subject getDefaults() {
        return this.service.getDefaults();
    }

    public final void suggestUnload(@Nonnull String identifier) {
    }
}

