/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.permissions.sponge.subject.base.group;

import javax.annotation.Nonnull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.SubjectCollection;
import systems.reformcloud.reformcloud2.permissions.PermissionAPI;
import systems.reformcloud.reformcloud2.permissions.sponge.subject.impl.AbstractGroupSubject;
import systems.reformcloud.reformcloud2.permissions.util.group.PermissionGroup;

public class GroupSubject
extends AbstractGroupSubject {
    private final PermissionService service;
    private final SubjectCollection source;
    private final String group;

    public GroupSubject(@Nonnull String group, @Nonnull PermissionService service, @NonNull SubjectCollection source) {
        super(group);
        this.service = service;
        this.source = source;
        this.group = group;
    }

    @Override
    protected PermissionService service() {
        return this.service;
    }

    @Override
    protected boolean has(String permission) {
        PermissionGroup permissionGroup = PermissionAPI.getInstance().getPermissionUtil().getGroup(this.group);
        if (permissionGroup == null) {
            return false;
        }
        return PermissionAPI.getInstance().getPermissionUtil().hasPermission(permissionGroup, permission.toLowerCase());
    }

    public @NonNull SubjectCollection getContainingCollection() {
        return this.source;
    }

    @Nonnull
    public String getIdentifier() {
        return this.group;
    }
}

