/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.permissions.sponge.service;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.service.context.ContextCalculator;
import org.spongepowered.api.service.permission.PermissionDescription;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectCollection;
import org.spongepowered.api.service.permission.SubjectReference;
import systems.reformcloud.reformcloud2.permissions.sponge.collections.CollectionCatalog;
import systems.reformcloud.reformcloud2.permissions.sponge.description.SpongePermissionDescriptionBuilder;
import systems.reformcloud.reformcloud2.permissions.sponge.reference.SpongeSubjectReference;
import systems.reformcloud.reformcloud2.permissions.sponge.subject.util.SubjectDefaultData;

public class SpongePermissionService
implements PermissionService {
    private static final Map<String, SubjectCollection> LOADED = new HashMap<String, SubjectCollection>();
    public static final Map<String, PermissionDescription> DESCRIPTIONS = new ConcurrentHashMap<String, PermissionDescription>();
    private static SpongePermissionService instance;

    public static SpongePermissionService getInstance() {
        return instance;
    }

    public SpongePermissionService() {
        instance = this;
    }

    @Nonnull
    public SubjectCollection getUserSubjects() {
        return CollectionCatalog.USER_COLLECTION;
    }

    @Nonnull
    public SubjectCollection getGroupSubjects() {
        return CollectionCatalog.GROUP_COLLECTION;
    }

    @Nonnull
    public Subject getDefaults() {
        return SubjectDefaultData.DEFAULT;
    }

    @Nonnull
    public Predicate<String> getIdentifierValidityPredicate() {
        return s -> true;
    }

    @Nonnull
    public CompletableFuture<SubjectCollection> loadCollection(@Nonnull String identifier) {
        return CompletableFuture.completedFuture(LOADED.getOrDefault(identifier, CollectionCatalog.FACTORY_COLLECTION));
    }

    @Nonnull
    public Optional<SubjectCollection> getCollection(@Nonnull String identifier) {
        return Optional.ofNullable(this.loadCollection(identifier).join());
    }

    @Nonnull
    public CompletableFuture<Boolean> hasCollection(@Nonnull String identifier) {
        return CompletableFuture.completedFuture(this.getCollection(identifier).isPresent());
    }

    @Nonnull
    public Map<String, SubjectCollection> getLoadedCollections() {
        return Collections.unmodifiableMap(LOADED);
    }

    @Nonnull
    public CompletableFuture<Set<String>> getAllIdentifiers() {
        return CompletableFuture.completedFuture(LOADED.keySet());
    }

    @Nonnull
    public SubjectReference newSubjectReference(@Nonnull String collectionIdentifier, @Nonnull String subjectIdentifier) {
        return new SpongeSubjectReference(this, collectionIdentifier, subjectIdentifier);
    }

    @Nonnull
    public PermissionDescription.Builder newDescriptionBuilder(@Nonnull Object plugin) {
        return new SpongePermissionDescriptionBuilder(this, Sponge.getPluginManager().fromInstance(plugin).orElse(null));
    }

    @Nonnull
    public Optional<PermissionDescription> getDescription(@Nonnull String permission) {
        return Optional.ofNullable(DESCRIPTIONS.get(permission));
    }

    @Nonnull
    public Collection<PermissionDescription> getDescriptions() {
        return DESCRIPTIONS.values();
    }

    public void registerContextCalculator(@Nullable ContextCalculator<Subject> calculator) {
    }

    static {
        LOADED.put("commandblock", CollectionCatalog.COMMAND_BLOCK_COLLECTION);
        LOADED.put("system", CollectionCatalog.SYSTEM_COLLECTION);
        LOADED.put("user", CollectionCatalog.USER_COLLECTION);
        LOADED.put("defaults", CollectionCatalog.FACTORY_COLLECTION);
        LOADED.put("group", CollectionCatalog.GROUP_COLLECTION);
        LOADED.put("role-template", CollectionCatalog.GROUP_COLLECTION);
    }
}

