/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.permissions.nukkit.permissible;

import cn.nukkit.Player;
import cn.nukkit.permission.Permissible;
import cn.nukkit.permission.PermissibleBase;
import cn.nukkit.permission.Permission;
import cn.nukkit.permission.PermissionAttachment;
import cn.nukkit.permission.PermissionAttachmentInfo;
import cn.nukkit.permission.ServerOperator;
import cn.nukkit.plugin.Plugin;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import systems.reformcloud.reformcloud2.executor.api.common.ExecutorAPI;
import systems.reformcloud.reformcloud2.executor.api.common.process.ProcessInformation;
import systems.reformcloud.reformcloud2.permissions.PermissionAPI;
import systems.reformcloud.reformcloud2.permissions.util.group.NodeGroup;
import systems.reformcloud.reformcloud2.permissions.util.group.PermissionGroup;
import systems.reformcloud.reformcloud2.permissions.util.permission.PermissionNode;
import systems.reformcloud.reformcloud2.permissions.util.user.PermissionUser;

public class DefaultPermissible
extends PermissibleBase {
    private final UUID uuid;
    private Map<String, PermissionAttachmentInfo> perms;

    public DefaultPermissible(Player player) {
        super((ServerOperator)player);
        this.uuid = player.getUniqueId();
    }

    public boolean isOp() {
        return false;
    }

    public void setOp(boolean value) {
    }

    public boolean isPermissionSet(String name) {
        return this.has(name);
    }

    public boolean isPermissionSet(Permission perm) {
        return this.has(perm.getName());
    }

    public boolean hasPermission(String name) {
        return this.has(name);
    }

    public boolean hasPermission(Permission perm) {
        return this.has(perm.getName());
    }

    public PermissionAttachment addAttachment(Plugin plugin, String name, Boolean value) {
        return new PermissionAttachment(plugin, (Permissible)this);
    }

    public PermissionAttachment addAttachment(Plugin plugin) {
        return new PermissionAttachment(plugin, (Permissible)this);
    }

    public void removeAttachment(PermissionAttachment attachment) {
    }

    public void recalculatePermissions() {
    }

    public synchronized void clearPermissions() {
    }

    public Map<String, PermissionAttachmentInfo> getEffectivePermissions() {
        this.perms = new ConcurrentHashMap<String, PermissionAttachmentInfo>();
        PermissionUser permissionUser = PermissionAPI.getInstance().getPermissionUtil().loadUser(this.uuid);
        ProcessInformation current = ExecutorAPI.getInstance().getSyncAPI().getProcessSyncAPI().getThisProcessInformation();
        permissionUser.getPermissionNodes().stream().filter(PermissionNode::isValid).forEach(e -> this.perms.put(e.getActualPermission(), new PermissionAttachmentInfo((Permissible)this, e.getActualPermission(), null, e.isSet())));
        permissionUser.getGroups().stream().filter(NodeGroup::isValid).map(e -> PermissionAPI.getInstance().getPermissionUtil().getGroup(e.getGroupName())).filter(Objects::nonNull).flatMap(e -> {
            Stream.Builder<PermissionGroup> stream = Stream.builder().add((PermissionGroup)e);
            e.getSubGroups().stream().map(g -> PermissionAPI.getInstance().getPermissionUtil().getGroup((String)g)).filter(Objects::nonNull).forEach(stream);
            return stream.build();
        }).forEach(g -> {
            Collection<PermissionNode> nodes;
            g.getPermissionNodes().stream().filter(PermissionNode::isValid).forEach(e -> this.perms.put(e.getActualPermission(), new PermissionAttachmentInfo((Permissible)this, e.getActualPermission(), null, e.isSet())));
            if (current != null && (nodes = g.getPerGroupPermissions().get(current.getProcessGroup().getName())) != null) {
                nodes.stream().filter(PermissionNode::isValid).forEach(e -> this.perms.put(e.getActualPermission(), new PermissionAttachmentInfo((Permissible)this, e.getActualPermission(), null, e.isSet())));
            }
        });
        return this.perms;
    }

    public PermissionAttachment addAttachment(Plugin plugin, String name) {
        return new PermissionAttachment(plugin, (Permissible)this);
    }

    private boolean has(String name) {
        PermissionUser permissionUser = PermissionAPI.getInstance().getPermissionUtil().loadUser(this.uuid);
        return permissionUser.hasPermission(name);
    }
}

