/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.rethink;

import com.fasterxml.jackson.core.type.TypeReference;
import com.rethinkdb.RethinkDB;
import com.rethinkdb.gen.ast.Db;
import com.rethinkdb.gen.ast.Table;
import com.rethinkdb.model.MapObject;
import com.rethinkdb.net.Connection;
import com.rethinkdb.net.Result;
import com.rethinkdb.utils.Types;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;
import systems.reformcloud.reformcloud2.executor.api.configuration.gson.JsonConfiguration;
import systems.reformcloud.reformcloud2.executor.api.wrappers.DatabaseTableWrapper;

public class RethinkDatabaseTableWrapper
implements DatabaseTableWrapper {
    private static final TypeReference<Map<String, String>> STRING_MAP_TYPE = Types.mapOf(String.class, String.class);
    private final Connection connection;
    private final Table table;

    public RethinkDatabaseTableWrapper(Connection connection, Db database, String targetTable) {
        this.connection = connection;
        this.table = database.table((Object)targetTable);
    }

    public void insert(@NotNull String key, @NotNull String id, @NotNull JsonConfiguration data) {
        Optional<JsonConfiguration> jsonConfiguration = this.find(key, id);
        if (jsonConfiguration.isPresent()) {
            this.table.update(this.asMap(key, id, data)).runNoReply(this.connection);
        } else {
            this.table.insert(this.asMap(key, id, data)).runNoReply(this.connection);
        }
    }

    public void update(@NotNull String key, @NotNull String id, @NotNull JsonConfiguration newData) {
        this.insert(key, id, newData);
    }

    public void remove(@NotNull String key, @NotNull String id) {
        this.table.filter(this.asMap(key, id)).delete().runNoReply(this.connection);
    }

    @NotNull
    public Optional<JsonConfiguration> get(@NotNull String key, @NotNull String id) {
        return this.find(key, id);
    }

    @NotNull
    public @UnmodifiableView Collection<String> getEntryNames() {
        ArrayList<String> result = new ArrayList<String>();
        try (Result run = this.table.run(this.connection, STRING_MAP_TYPE);){
            while (run.hasNext()) {
                Map map = (Map)run.next();
                if (map == null) continue;
                result.add((String)map.get("_key"));
            }
        }
        return result;
    }

    public long count() {
        return this.getEntryNames().size();
    }

    public void clear() {
        this.table.delete().runNoReply(this.connection);
    }

    @NotNull
    public @UnmodifiableView Collection<JsonConfiguration> getAll() {
        ArrayList<JsonConfiguration> result = new ArrayList<JsonConfiguration>();
        try (Result run = this.table.run(this.connection, STRING_MAP_TYPE);){
            while (run.hasNext()) {
                Map map = (Map)run.next();
                if (map == null) continue;
                result.add(new JsonConfiguration((String)map.get("values")));
            }
        }
        return result;
    }

    public boolean has(@NotNull String key) {
        return this.find(key, null).isPresent();
    }

    private Optional<JsonConfiguration> find(String key, @Nullable String id) {
        Result result = this.table.filter(this.asMap(key, id)).run(this.connection, Types.mapOf(String.class, String.class));
        if (result.hasNext()) {
            Map map = (Map)result.first();
            return map == null ? Optional.empty() : Optional.of(new JsonConfiguration((String)map.get("values")));
        }
        return Optional.empty();
    }

    private MapObject<Object, Object> asMap(String key, @Nullable String id) {
        MapObject result = RethinkDB.r.hashMap((Object)"_key", (Object)key);
        if (id != null) {
            result.with((Object)"_identifier", (Object)id);
        }
        return result;
    }

    private MapObject<Object, Object> asMap(String key, String id, JsonConfiguration data) {
        return this.asMap(key, id).with((Object)"values", (Object)data.toPrettyString());
    }
}

