/*
 * Decompiled with CFR 0.152.
 */
package systems.reformcloud.reformcloud2.rethink;

import com.rethinkdb.RethinkDB;
import com.rethinkdb.gen.ast.Db;
import com.rethinkdb.net.Connection;
import com.rethinkdb.net.Result;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;
import systems.reformcloud.reformcloud2.executor.api.provider.DatabaseProvider;
import systems.reformcloud.reformcloud2.executor.api.wrappers.DatabaseTableWrapper;
import systems.reformcloud.reformcloud2.rethink.RethinkDatabaseTableWrapper;
import systems.reformcloud.reformcloud2.rethink.config.RethinkConfig;

public class RethinkDatabaseProvider
implements DatabaseProvider,
AutoCloseable {
    private final Connection connection;
    private final Db database;

    public RethinkDatabaseProvider(RethinkConfig config) {
        this.connection = RethinkDB.r.connection().hostname(config.getHost()).port(Integer.valueOf(config.getPort())).user(config.getUserName(), config.getPassword()).db(config.getDatabase()).connect();
        this.database = RethinkDB.r.db((Object)config.getDatabase());
    }

    @NotNull
    public DatabaseTableWrapper createTable(@NotNull String tableName) {
        return new RethinkDatabaseTableWrapper(this.connection, this.database, tableName);
    }

    public void deleteTable(@NotNull String tableName) {
        this.database.tableDrop((Object)tableName).run(this.connection);
    }

    @NotNull
    public @UnmodifiableView Collection<String> getTableNames() {
        try (Result result = this.database.tableList().run(this.connection, String.class);){
            List list = result.toList();
            return list;
        }
    }

    @NotNull
    public DatabaseTableWrapper getDatabase(@NotNull String tableName) {
        return new RethinkDatabaseTableWrapper(this.connection, this.database, tableName);
    }

    @Override
    public void close() {
        this.connection.close();
    }
}

